/*
 * gehl.c
 * Graphics Easy Hangling Library
 */
#include <stdio.h>
/* types */
#include "gehl_types.h"
/* functions */
#include "gehl.h"
#include "gehl_fileio.h"
#include "gehl_turnover.h"
#include "gehl_rotate.h"
#include "gehl_trim.h"
#include "gehl_bw.h"
#include "gehl_util.h"
#include "gehl_edge.h"


/* ɤ߹
   եޥåȤϼưȽ̤ */
int
GEHL_Load(const char *fname, GEHL_IMG *img)
{
    return __GEHL_Load(fname, img);
}

/* ¸
   ߤΤȤWindows bitmap Τ */
int
GEHL_Save(const char *fname, const GEHL_IMG *img, int format)
{
    return __GEHL_Save(fname, img, format);
}

/*  */
int
GEHL_Free(GEHL_IMG *img)
{
    return __GEHL_Free(img);
}

/* ȿž
   VERTICAL --- 岼
   HORIZONTAL ---  */
int
GEHL_Turnover(GEHL_IMG *img, int direction)
{
    return __GEHL_Turnover(img, direction);
}

/* ž
   ײ 1-359 */
int
GEHL_Rotate(GEHL_IMG *img, double degree)
{
    return __GEHL_Rotate(img, degree);
}

/* ȥߥ󥰤
   ϰϤ(x, y)-(x+w, y+h) */
int
GEHL_Trim(GEHL_IMG *img,
          int x, int y,
          int w, int h)
{
    return __GEHL_Trim(img, x, y, w, h);
}

/* Ͳ
   24bitΤб */
int
GEHL_C2Mono(GEHL_IMG *img, int border)
{
    return __GEHL_C2Mono(img, border);
}

/* 򥰥졼벽
   24bitΤб */
int
GEHL_C2Gray(GEHL_IMG *img)
{
    return __GEHL_C2Gray(img);
}

/* 򥳥ԡ */
int
GEHL_Copy(GEHL_IMG *dest, const GEHL_IMG *src)
{
    return __GEHL_Copy(dest, src);
}

/* سФ */
int
GEHL_Edge(GEHL_IMG *img, int filter)
{
    return __GEHL_Edge(img, filter);
}
