/*
 * gehl_bmp_def.h
 * 2002.05.09 
 * Ȥꤢ1bit24bitΤߥݡ
 */

#ifndef _gehl_bmp_def_h
#define _gehl_bmp_def_h

#ifdef __cplusplus
extern "C"{
#endif


/* BITMAPFILEHEADER */
#define GEHL_BMP_SIZE_BFH 14
#define GEHL_BMP_OFFSET_BFTYPE 0
#define GEHL_BMP_OFFSET_BFSIZE 2
#define GEHL_BMP_OFFSET_BFOFFBITS 10

/* BITMAPINFOHEADER */
#define GEHL_BMP_OFFSET_BISIZE GEHL_BMP_SIZE_BFH
#define GEHL_BMP_OFFSET_BIWIDTH (GEHL_BMP_OFFSET_BISIZE+4)
#define GEHL_BMP_OFFSET_BIHEIGHT (GEHL_BMP_OFFSET_BIWIDTH+4)
#define GEHL_BMP_OFFSET_BIBITCOUNT (GEHL_BMP_OFFSET_BIHEIGHT+4+2)
#define GEHL_BMP_OFFSET_BISIZEIMAGE (GEHL_BMP_OFFSET_BIBITCOUNT+2+4)

#define GEHL_BMP_SIGN 0
#define GEHL_BMP_WIDTH GEHL_BMP_OFFSET_BIWIDTH
#define GEHL_BMP_HEIGHT GEHL_BMP_OFFSET_BIHEIGHT
#define GEHL_BMP_BITS GEHL_BMP_OFFSET_BIBITCOUNT
/*#define GEHL_BMP_IMAGESIZE GEHL_BMP_OFFSET_BISIZEIMAGE*/

#define GEHL_BMP_HEADSIZE GEHL_BMP_OFFSET_BISIZEIMAGE+4

#define GEHL_BMP_TYPE 0x4d42 /* 'BM' */

typedef struct{
    unsigned short dummy;
    unsigned short bfType;
    unsigned long bfSize;
    unsigned short bfReserved1;
    unsigned short bfReserved2;
    unsigned long bfOffBits;
} GEHL_BMP_FH;

typedef struct{
    unsigned long biSize;
    long biWidth;
    long biHeight;
    unsigned short biPlanes;/* must be 1 */
    unsigned short biBitCount;
    unsigned long biCompression; /* ޤǤϿѤƤȻפ */
    unsigned long biSizeImage;
    long biXPixPerMeter;
    long biYPixPerMeter;
    unsigned long biClrUsed;
    unsigned long biClrImportant;
} GEHL_BMP_IH;

typedef struct{
    unsigned char rgbBlue;
    unsigned char rgbGreen;
    unsigned char rgbRed;
    unsigned char rgbReserved; /* must be 0 */
} GEHL_BMP_RGBQUAD;


#ifdef __cplusplus
}
#endif

#endif /* _gehl_bmp_def_h */
