/*
 * gehl_edge.c
 * 摜̗֊so
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gehl_types.h"
#include "gehl_edge.h"


#define CORRECT 0 /* ␳l */


static int
sobel_x[] = {
    1, 0, -1,
    2, 0, -2,
    1, 0, -1
};
static int
sobel_y[] = {
    1, 2, 1,
    0, 0, 0,
    -1, -2, -1
};

static int
prewitt_x[] = {
    1, 0, -1,
    1, 0, -1,
    1, 0, -1
};
static int
prewitt_y[] = {
    1, 2, 1,
    0, 0, 0,
    -1, -2, -1
};


static int
Edge_8(GEHL_IMG *img, int filter);


int
__GEHL_Edge(GEHL_IMG *img, int filter)
{
    int ret = -1;
    int i, flag;

    switch(img->bits) {
    case 8:
        flag = 1;
        for (i = 0; i < 256; i++) {
            if (img->ppalette[i].red == i &&
                img->ppalette[i].blue == i &&
                img->ppalette[i].green == i) {
                continue;
            } else {
                flag = 0;
                break;
            }
        }

        if (flag == 0) {
            flag = 1;
            for (i = 0; i < 256; i++) {
                if (img->ppalette[i].red == 255-i &&
                    img->ppalette[i].blue == 255-i &&
                    img->ppalette[i].green == 255-i) {
                    continue;
                } else {
                    flag = 0;
                    break;
                }
            }
        }

        if (flag) {
            ret = Edge_8(img, filter);
        }
        break;

    default:
        break;
    }

    return ret;
}

/*
 * Sobel/Prewitt Filterg֊so
 * 8bitO[XP[݂̂Ŏgp
 * (pbgœKĂꍇ́As)
 */
static int
Edge_8(GEHL_IMG *img, int filter)
{
    int *dx, *dy, d[9];
    int i, j, k, dat, width;
    unsigned char *pread0, *pread1, *pread2, *pwrite;
    int ix, iy;
    int in_w, in_h;
    GEHL_IMG outimg;

    switch (filter) {

    case GEHL_EDGEFILTER_SOBEL:
        dx = sobel_x;
        dy = sobel_y;
        break;

    case GEHL_EDGEFILTER_PREWITT:
        dx = prewitt_x;
        dy = prewitt_y;
        break;

    default:
        return -1;
    }

    width = img->width;
    in_w = img->width - 2;
    in_h = img->height;

    outimg = *img;
    outimg.pdata = NULL;
    outimg.pred = outimg.pgreen = outimg.pblue = NULL;

    outimg.pdata = malloc(outimg.width * outimg.height);
    if (NULL == outimg.pdata) return -1;
    memset(outimg.pdata, 0, outimg.width * outimg.height);

    pread0 = img->pdata;
    pread1 = pread0 + width;
    pread2 = pread1 + width;
    pwrite = outimg.pdata + width;

    for (i = 1; i < in_h - 1; i++) {
        for (j = 1; j < in_w - 1; j++) {
            d[0] = (int)pread0[j-1];
            d[1] = (int)pread0[j];
            d[2] = (int)pread0[j+1];
            d[3] = (int)pread1[j-1];
            d[4] = (int)pread1[j];
            d[5] = (int)pread1[j+1];
            d[6] = (int)pread2[j-1];
            d[7] = (int)pread2[j];
            d[8] = (int)pread2[j+1];

            ix = 0; iy = 0;
            for (k = 0; k < 9; k++) {
                ix += d[k]*dx[k];
                iy += d[k]*dy[k];
            }
            ix = (ix < 0) ? -ix : ix;
            iy = (iy < 0) ? -iy : iy;

            dat = ix + iy + CORRECT;  /* ̋ߎl+␳ */
            dat = (dat > 255) ? 255 : ( (dat < 0) ? 0 : dat );

            pwrite[j+1] = (unsigned char)dat;
        }

        pread0 += width;
        pread1 += width;
        pread2 += width;
        pwrite += width;
    }

    memmove(img->pdata, outimg.pdata, outimg.width*outimg.height);
    free(outimg.pdata);

    return 0;
}
