/*
 * gehl_turnover.c
 * 岼ȿžǽ
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gehl_types.h"
#include "gehl_turnover.h"


static int
Turnover8(GEHL_IMG *img, int direction);

static int
Turnover24(GEHL_IMG *img, int direction);


/*
 * ᡼岼ȿž
 * direction == 0 (VEERTICAL): 岼
 * direction != 0 : 
 */
int
__GEHL_Turnover(GEHL_IMG *img, int direction)
{
    int ret = -1;

    if (NULL == img)
        return ret;

    switch (img->bits) {

    case 1:
    case 8:
        ret = Turnover8(img, direction);
        break;

    case 24:
        ret = Turnover24(img, direction);
        break;
    }

    return ret;
}

/*
 * 8bitȿžؿ
 * 岼
 */
static int
Turnover8(GEHL_IMG *img, int direction)
{
    char *buf;
    char *src, *dist;
    char tmp;
    int x, y;

    buf = (char *)malloc(img->height*img->rowbytes);
    if (NULL==buf){
        return -1;
    }

    if (direction == VERTICAL){/* 岼ȿž */
        src = img->pdata;
        dist = img->pdata + img->rowbytes * (img->height-1);
        for (y = 0; y < img->height/2; y++){
            memcpy(buf, src, img->rowbytes);
            memcpy(src, dist, img->rowbytes);
            memcpy(dist, buf, img->rowbytes);
            src += img->rowbytes;
            dist -= img->rowbytes;
        }
    } else {/* ȿž */
        src = img->pdata;
        for (y = 0; y < img->height; y++){
            memcpy(buf, src, img->rowbytes);
            for (x = 0; x < img->width/2; x++){
                tmp = buf[x];
                buf[x] = buf[img->width-1-x];
                buf[img->width-1-x] = tmp;
            }
            memcpy(src, buf, img->rowbytes);
            src += img->rowbytes;
        }
    }

    free(buf);
    return 0;
}


/*
 * 24bitȿžؿ
 * 岼
 */
static int
Turnover24(GEHL_IMG *img, int direction)
{
    char *buf;
    char *src, *dist;
    int x, y;

    buf = (char *)malloc(img->width);
    if (NULL==buf){
        return -1;
    }

    if (direction == VERTICAL){/* 岼ȿž */
        src = img->pred;
        dist = img->pred + img->width * (img->height-1);
        for (y = 0; y < img->height/2; y++){
            memcpy(buf, src, img->width);
            memcpy(src, dist, img->width);
            memcpy(dist, buf, img->width);
            src += img->width;
            dist -= img->width;
        }
        src = img->pgreen;
        dist = img->pgreen + img->width * (img->height-1);
        for (y = 0; y < img->height/2; y++){
            memcpy(buf, src, img->width);
            memcpy(src, dist, img->width);
            memcpy(dist, buf, img->width);
            src += img->width;
            dist -= img->width;
        }
        src = img->pblue;
        dist = img->pblue + img->width * (img->height-1);
        for (y = 0; y < img->height/2; y++){
            memcpy(buf, src, img->width);
            memcpy(src, dist, img->width);
            memcpy(dist, buf, img->width);
            src += img->width;
            dist -= img->width;
        }
    } else {/* ȿž */
        src = img->pred;
        for (y = 0; y < img->height; y++){
            for (x = img->width; x > 0; x--)
                buf[x - 1] = src[img->width - x];
            memcpy(src, buf, img->width);
            src += img->width;
        }
        src = img->pgreen;
        for (y = 0; y < img->height; y++){
            for (x = img->width; x > 0; x--)
                buf[x - 1] = src[img->width - x];
            memcpy(src, buf, img->width);
            src += img->width;
        }
        src = img->pblue;
        for (y = 0; y < img->height; y++){
            for (x = img->width; x > 0; x--)
                buf[x - 1] = src[img->width - x];
            memcpy(src, buf, img->width);
            src += img->width;
        }
    }

    free(buf);
    return 0;
}
