/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: thumbtable.h,v 1.1.2.2 2003/05/12 13:00:32 makeinu Exp $
 */

#ifndef __THUMBTABLE_H__
#define __THUMBTABLE_H__

#include "gimageview.h"
#include "thumbnail_view.h"

#define THUMB_TABLE_LABEL "Thumbnail"
#define RENAME_MODE_LABEL "Rename Mode"

GList     *thumbtable_append_thumb_frames      (ThumbView      *tv,
                                                GList          *start,
                                                gchar          *dest_mode);
GtkWidget *thumbtable_add_thumbnail            (Thumbnail      *thumb,
                                                gchar          *dest_mode,
                                                ThumbLoadType   type);
void       thumbtable_redraw                   (ThumbView      *tv,
                                                gchar          *mode,
                                                GtkWidget      *scroll_win,
                                                GList         **loadlist);
gboolean   thumbtable_refresh_thumbnail        (Thumbnail      *thumb,
                                                ThumbLoadType   type);
GtkWidget *thumbtable_resize                   (ThumbView      *tv);
void       thumbtable_adjust                   (ThumbView      *tv,
                                                Thumbnail      *thumb);
GtkWidget *thumbtable_create                   (ThumbView      *tv,
                                                gchar          *dest_mode);
void       thumbtable_remove_thumbview_data    (ThumbView      *tv);
void       thumbtable_remove_thumbnail_data    (Thumbnail      *thumb);
gboolean   thumbtable_set_selection            (Thumbnail      *thumb,
                                                gboolean        select);
void       thumbtable_set_focus                (ThumbView      *tv,
                                                Thumbnail      *thumb);
Thumbnail *thumbtable_get_focus                (ThumbView      *tv);
gboolean   thumbtable_thumbnail_is_in_viewport (ThumbView      *tv,
                                                Thumbnail      *thumb);

#endif /* __THUMBTABLE_H__ */
