/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001-2002 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: image_loader.h,v 1.5.2.6 2003/05/14 15:30:00 makeinu Exp $
 */

#ifndef __IMAGE_LOADER_H__
#define __IMAGE_LOADER_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtkobject.h>

#include "gimv_image.h"
#include "gimv_io.h"
#include "image_info.h"

#define IMAGE_LOADER(obj)         GTK_CHECK_CAST (obj, image_loader_get_type (), ImageLoader)
#define IMAGE_LOADER_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, image_loader_get_type, ImageLoaderClass)
#define IS_IMAGE_LOADER(obj)      GTK_CHECK_TYPE (obj, image_loader_get_type ())


typedef struct ImageLoader_Tag      ImageLoader;
typedef struct ImageLoaderPriv_Tag  ImageLoaderPriv;
typedef struct ImageLoaderClass_Tag ImageLoaderClass;


typedef enum {
   IMAGE_LOADER_LOAD_NORMAL,
   IMAGE_LOADER_LOAD_THUMBNAIL
} ImageLoaderLoadType;


struct ImageLoader_Tag
{
   GtkObject parent;

   ImageInfo *info;

   ImageLoaderPriv *priv;
};


struct ImageLoaderClass_Tag
{
   GtkObjectClass parent;

   void (*load_start)        (ImageLoader *il);
   void (*progress_update)   (ImageLoader *il);
   void (*load_end)          (ImageLoader *il);
};


#define GIMV_IMAGE_LOADER_IF_VERSION 1

/*
 *  for plugin
 */
typedef enum {
   GIMV_IMAGE_LOADER_PRIORITY_HIGH          = -255,
   GIMV_IMAGE_LOADER_PRIORITY_CAN_CANCEL    = -127,
   GIMV_IMAGE_LOADER_PRIORITY_DEFAULT       = 0,
   GIMV_IMAGE_LOADER_PRIORITY_CANNOT_CANCEL = 127,
   GIMV_IMAGE_LOADER_PRIORITY_LOW           = 255
} GimvImageLoaderPriority;

typedef struct ImageLoaderPlugin_Tag
{
   const guint32           if_version; /* plugin interface version */
   const gchar * const     id;
   GimvImageLoaderPriority priority_hint;

   const gchar       *(*check_type)    (ImageLoader  *loader,
                                        gpointer      data);
   gboolean          *(*get_info)      (ImageLoader  *loader,
                                        gpointer      data);
   GimvImage         *(*loader)        (ImageLoader  *loader,
                                        gpointer      data);
} ImageLoaderPlugin;

guint        image_loader_get_type            (void);
ImageLoader *image_loader_new                 (void);
ImageLoader *image_loader_new_with_image_info (ImageInfo   *info);
ImageLoader *image_loader_new_with_file_name  (const gchar *filename);
ImageLoader *image_loader_ref                 (ImageLoader *loader);
void         image_loader_unref               (ImageLoader *loader);
void         image_loader_set_image_info      (ImageLoader *loader,
                                               ImageInfo   *info);


void         image_loader_set_gio             (ImageLoader *loader,
                                               GimvIO      *gio);
gboolean     image_loader_set_as_animation    (ImageLoader *loader,
                                               gboolean     animation);
gboolean     image_loader_set_load_type       (ImageLoader *loader,
                                               ImageLoaderLoadType type);
gboolean     image_loader_set_scale           (ImageLoader *loader,
                                               gfloat       w_scale,
                                               gfloat       h_scale);
gboolean     image_loader_set_size_request    (ImageLoader *loader,
                                               gint         width,
                                               gint         height);
void         image_loader_load                (ImageLoader *loader);
void         image_loader_load_start          (ImageLoader *loader);
void         image_loader_load_stop           (ImageLoader *loader);
gboolean     image_loader_is_loading          (ImageLoader *loader);
GimvImage   *image_loader_get_image           (ImageLoader *loader);
void         image_loader_unref_image         (ImageLoader *loader);

/* used by loader module */
GimvIO      *image_loader_get_gio             (ImageLoader *loader);
const gchar *image_loader_get_path            (ImageLoader *loader);
ImageLoaderLoadType
             image_loader_get_load_type      (ImageLoader *loader);
gboolean     image_loader_load_as_animation   (ImageLoader *loader);
gboolean     image_loader_get_scale           (ImageLoader *loader,
                                               gfloat      *width_scale_ret,
                                               gfloat      *height_scale_ret);
gboolean     image_loader_get_size_request    (ImageLoader *loader,
                                               gint        *width_ret,
                                               gint        *height_ret);
gboolean     image_loader_progress_update     (ImageLoader *loader);

#endif /* __IMAGE_LOADER_H__ */
