/*
 * Decompiled with CFR 0.152.
 */
package org.ginkgo.gcov.popup.actions;

import java.io.File;
import java.util.HashMap;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class Action
implements IObjectActionDelegate {
    private Shell shell;
    private IProject project;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        this.parse(null);
        this.parse2(null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o instanceof IProject) {
            this.project = (IProject)o;
        } else if (o instanceof ICProject) {
            this.project = (IProject)((ICProject)o).getAdapter(IProject.class);
        }
    }

    public void parse(IFile file1) {
        String[] cmdLine = new String[]{"lcov", "-c", "-d", ".", "-o", "app.info"};
        IPath workingDirectory = this.project.getLocation();
        File workingDir = null;
        if (workingDirectory != null) {
            workingDir = workingDirectory.toFile();
        }
        String[] envp = null;
        Process p = null;
        try {
            p = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IProcess process = null;
        String programName = cmdLine[0];
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        if (p != null && (process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)programName, processAttributes)) == null) {
            p.destroy();
        }
        while (!process.isTerminated()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String errorText = process.getStreamsProxy().getErrorStreamMonitor().getContents();
        System.out.println(errorText);
        String outputText = process.getStreamsProxy().getOutputStreamMonitor().getContents();
        System.out.println(outputText);
    }

    public void parse2(IFile file1) {
        String[] cmdLine = new String[]{"genhtml", "-o", "doc", "-p", "`pwd`", "--num-space", "4", "-f", "app.info"};
        IPath workingDirectory = this.project.getLocation();
        File workingDir = null;
        if (workingDirectory != null) {
            workingDir = workingDirectory.toFile();
        }
        String[] envp = null;
        Process p = null;
        try {
            p = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IProcess process = null;
        String programName = cmdLine[0];
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        if (p != null && (process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)programName, processAttributes)) == null) {
            p.destroy();
        }
        while (!process.isTerminated()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String errorText = process.getStreamsProxy().getErrorStreamMonitor().getContents();
        System.out.println(errorText);
        String outputText = process.getStreamsProxy().getOutputStreamMonitor().getContents();
        System.out.println(outputText);
    }
}

