var g_isTrace = true;
var g_traceFrame = null;
var g_traceFrame_sid = null;

function g_traceFrame_scroll(){
	if(g_traceFrame && g_traceFrame.contentWindow){
		g_traceFrame.contentWindow.scrollBy(0,1000000);
	}
}

function trace(arg)
{
	if(!g_isTrace){
		return;
	}
	
	
	/*
	if(g_traceWin == null){
		g_traceWin = window.open("","debugWin","menubar=no,resizable=yes,scrollbars=yes");
		return ;
	}
	
	if(!g_traceWin.document){
		g_traceArg += arg;
		window.setTimeout("trace(g_traceArg)", 0);
	}
	
	var e = g_traceWin.document.createElement("pre");
	var t = g_traceWin.document.createTextNode(arg);
	e.appendChild(t);
	g_traceWin.document.body.appendChild(e);
	g_traceWin.scrollBy(0,1000000);
	*/
	
	g_traceFrame = getObjectById("debugFrame");
	if(g_traceFrame){
		var e = g_traceFrame.contentWindow.document.createElement("pre");
		var t = g_traceFrame.contentWindow.document.createTextNode(arg);
		e.appendChild(t);
		g_traceFrame.contentWindow.document.body.appendChild(e);
		window.setTimeout("g_traceFrame_scroll()", 0);
	}
	
	/*
	var debugField = getObjectById("debugText");
	if(debugField!=null){
		if(debugField.value.length > 5000){
			debugField.value = debugField.value.substr(debugField.value.length-4000);
		}
		debugField.value += arg + "\n";
	}
	*/
	
	
}


function switchTrace()
{
	g_isTrace = !g_isTrace;
	return g_isTrace;
}

function getObjectById(name) {
    if(document.getElementById) {
        return document.getElementById(name);
    } else if(document.all) {
        return document.all(name);
    } else if(document.layers) {
        return document.layers[name];
    } else {
        return null;
    }
}

function doGetText(url) {
	return doRequest(url,false).responseText;
}


function doGetXML(url) {
	return doRequest(url,false).responseXML;
}

function isParseError (doc) {
   return (doc.parseError!=null && doc.parseError.errorCode!=0) ||
		(doc.documentElement == null)||
		(doc.documentElement.tagName=='parsererror' 
         && doc.documentElement.namespaceURI==
           'http://www.mozilla.org/newlayout/xml/parsererror.xml') ;
}

function isResponseOK(req)
{
	return (req.readyState == 4) && (req.status == 200);
}

function showPopup(url, popupObj)
{
	var content = getObjectById(popupObj.id+"Content");
	content.src = url;
	
	popupObj.style.visibility = 'visible';
	content.style.visibility = 'visible';
}

function doAsyncRequest(url, onloadClosure) {
	var req = getRequest();
	onloadClosure.reqObj = req;
	req.onreadystatechange = function() {
		if(req.readyState == 4){
			// trace("async req response headers="+req.getAllResponseHeaders());
			onloadClosure.obj[onloadClosure.method](isResponseOK(req), onloadClosure.reqObj, onloadClosure.args);
		}
    }
    req.open("GET", url, true);
    req.send(null);
    return req;
}

function getRequest(){
	var ret;
	if(window.ActiveXObject){
		ret = new ActiveXObject("Msxml2.XMLHTTP");
	}
	else{
	    ret = new XMLHttpRequest();
    }
	return ret;
}

function doRequest(url,async) {
    var req = getRequest();
	
    req.open("GET", url, async);
    req.send(null);
	
	if(!async){
		// trace("requestURL="+url);
		// trace("content-length="+req.getResponseHeader("Content-Length"));
		// trace("st=" + req.status);
		// trace("responseText="+req.responseText);
	}
    return req;
}


function getElementsByTagName_alt(x, name1, name2)
{
	var ret = x.getElementsByTagName(name1);
	if(ret.length == 0){
		ret = x.getElementsByTagName(name2);
	}
	return ret;
}



function getScrollX() {
    if(window.scrollX) {
        return window.scrollX;
    } else if(window.pageXOffset) {
        return window.pageXOffset;
    } else if(document.documentElement && document.documentElement.scrollLeft) {
        return document.documentElement.scrollLeft;
    } else if(document.body && document.body.scrollLeft) {
        return document.body.scrollLeft;
    } else {
        return 0;
    }
}

function getScrollY() {
    if(window.scrollY) {
        return window.scrollY;
    } else if(window.pageYOffset) {
        return window.pageYOffset;
    } else if(document.documentElement && document.documentElement.scrollTop) {
        return document.documentElement.scrollTop;
    } else if(document.body && document.body.scrollTop) {
        return document.body.scrollTop;
    } else {
        return 0;
    }
}


function getClickableImageHTML(image_src, onclickmethod, id){
	
	return "<a href=\"#\" onclick=\""+onclickmethod+"\"><img "+(id?(" id="+id):"") +" border=0 src=\""+image_src+"\"></a>";
}


function object2queryString(obj)
{
	var ret="";
	for(var a in obj){
		if(ret!=""){
			ret += "&";
		}
		ret+= a+"="+obj[a];
	}
	return ret;
}


function divAnim(obj, xdest, ydest, mag, total_time)
{
	this.animId = divAnim.activeAnim.length;
	divAnim.activeAnim[this.animId] = this;
	
	this.timerId = null;
	
	if(obj){
		this.init(obj, xdest, ydest, mag, total_time);
	}
}

divAnim.prototype.init = function(obj, xdest, ydest, mag, total_time, onFinishCallback){
	this.obj = obj;
	this.totalTime = total_time;
	this.xdest = xdest;
	this.ydest = ydest;
	this.isActive = false;
	this.mag = mag;
	this.onFinishCallback = onFinishCallback;
}

divAnim.activeAnim = new Array();

divAnim.prototype.interval = 1;

function onDivAnimInterval(id)
{
	divAnim.activeAnim[id].onInterval();
}

divAnim.prototype.onFinish = function()
{
	if(this.onFinishCallback){
		this.onFinishCallback.obj[this.onFinishCallback.method](this.onFinishCallback.args);
	}
}

divAnim.prototype.onInterval = function()
{
	var t = (new Date()).getTime() - this.beginTime;
	var finish = false;
	if(t>this.totalTime){
		t = this.totalTime;
		finish = true;
	}
	
	var left = (this.xdest*t + this.xbegin*(this.totalTime-t))/this.totalTime;
	var top = (this.ydest*t + this.ybegin*(this.totalTime-t))/this.totalTime;
	
	this.obj.style.left = left;
	this.obj.style.top = top;
	
	if(this.mag != 1){
		this.obj.style.width = (this.widthBegin*this.mag*t + this.widthBegin*(this.totalTime-t))/this.totalTime;
		this.obj.style.height = (this.heightBegin*this.mag*t + this.heightBegin*(this.totalTime-t))/this.totalTime;
	}
	
	if(finish){
		this.onFinish();
		this.stop();
	}
}


divAnim.prototype.start = function()
{
	this.stop();
	this.beginTime = (new Date()).getTime();
	this.xbegin = this.obj.offsetLeft;
	this.ybegin = this.obj.offsetTop;
	this.widthBegin = parseInt(this.obj.style.width);
	this.heightBegin = parseInt(this.obj.style.height);
	
	/*
	alert("this.widthBegin="+this.widthBegin);
	alert("this.heightBegin="+this.heightBegin);
	*/
	
	this.timerId = setInterval("onDivAnimInterval("+this.animId+")", this.interval);
	this.isActive = true;
}

divAnim.prototype.destroy = function()
{
	this.stop();
	divAnim.activeAnim[this.animId] = null;
}

divAnim.prototype.stop = function()
{
	if(this.timerId){
		clearInterval(this.timerId);
		this.timerId = null;
	}
	this.isActive = false;
}


function getChildrenText(node)
{
	if(node==null){
		return "";
	}
	if(node.text){
		return node.text;
	}
	var ret="";
	var children = node.childNodes;
	if(children==null || children==undefined){
		return "";
	}
	for(var i=0;i<children.length; ++i){
		switch(children[i].nodeType){
			case 3:
			case 4:
				ret += children[i].nodeValue;
		}
	}
	return ret;
}


function aryGetIndexOf(ary, obj)
{
	for(var i=0; i<ary.length; ++i){
		if(ary[i] == obj)
			return i;
	}
	return -1;
}

function escapeForXML(str){
	if( (str==null) || (str==undefined)){
		return null;
	}
	if(str == ""){
		return "";
	}
	str = str.replace(/\"/g, '&quot;');
	str = str.replace(/\>/g, '&gt;');
	return str.replace(/\</g, '&lt;');
}

function getCurrentPath()
{
	return location.href.substring(0, location.href.lastIndexOf('/')+1);
}
