/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___V_M_H___
#define ___V_M_H___

#include "v/v_errors.h"


//#define ENABLE_SERIALIZER

// MACHINE COMMON CONSTANTS & MACROS

#ifdef __cplusplus
#include "VAppConstants.h"
#include "LMenu.h"
#include "LPane.h"
#include "LRadioGroup.h"
typedef class LPane VInfo;
typedef class LGWorld* VImageInfo;
typedef class LRadioGroup* VRadioGroupInfo;
#else
typedef void VInfo;
typedef void* VImageInfo;
typedef void LMenu;
#endif
typedef struct VMenuItemInfo {
	LMenu *	lmenu;
	short	where;
} VMenuItemInfo;
typedef struct {
	int id;
} VTreeNodeInfo;
#define V_DEFAULT_SPACING	5
#define V_DEFAULT_PADDING	1
#define V_DEFAULT_FSIZE		130
#define V_WINDOW_MIN_WIDTH	80
#define V_WINDOW_MIN_HEIGHT	40

#define USE_V_LAYOUT


#define _V_OP_START(err) \
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
		unlock(this);	\
		return err;		\
	}

#define V_OP_START _V_OP_START(V_ER_DESTROYED)

#define _V_OP_START_VOID	_V_OP_START()

#define _V_OP_START_EX(c) \
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
	VExError er;				\
		er.code = c;			\
		er.subcode1 = 0;		\
		er.subcode2 = 0;		\
		unlock(this);	\
		return er;		\
	}

#define V_OP_START_EX _V_OP_START_EX(V_ER_DESTROYED)

#define V_OP_END	\
	unlock(this);

/*
#define SET_RGB8_32(pix,r,g,b,a) do {     \
        ((unsigned char*)(&pix))[0] = (a); \
        ((unsigned char*)(&pix))[1] = (r); \
        ((unsigned char*)(&pix))[2] = (g); \
        ((unsigned char*)(&pix))[3] = (b); \
} while(0)
*/

#define SET_RGB8_32(pix,r,g,b,a) {     \
	unsigned char * ___ptr;	\
\
	___ptr = (unsigned char*)&(pix); \
	*___ptr++ = (a); \
        *___ptr++ = (r); \
        *___ptr++ = (g); \
        *___ptr++ = (b); \
}

/*
#define GET_RGB8_32(pix,r,g,b,a) do {     \
        a = ((unsigned char*)(&pix))[0]; \
        r = ((unsigned char*)(&pix))[1]; \
        g = ((unsigned char*)(&pix))[2]; \
        b = ((unsigned char*)(&pix))[3]; \
} while(0)
*/

#define GET_RGB8_32(pix,r,g,b,a) {     \
	unsigned char * ___ptr; \
\
	___ptr = (unsigned char*)&(pix);	\
        a = *___ptr++; \
        r = *___ptr++; \
        g = *___ptr++; \
        b = *___ptr++; \
}


#define IS_RGB8_32(pix,r,g,b,a)                \
        (((unsigned char*)(&pix))[0] == (a) && \
         ((unsigned char*)(&pix))[1] == (r) && \
         ((unsigned char*)(&pix))[2] == (g) && \
         ((unsigned char*)(&pix))[3] == (b) )

#define RGB8_MAX	255

//extern "C" int ms_do(int (*func)(), void * arg,int, char str[]);
#ifdef __cplusplus
extern "C" int ms_do(int(*)(),void*,char*);
#else
int ms_do(int(*)(),void*,char*);
#endif
#define V_SERIALIZED_EXEC(func, arg)  ms_do((int(*)())func, (void*)arg, (char*)__func__)


enum VdataType {
	VDT_NONE	= 0,
	VDT_STRING	= 'TEXT',
	VDT_IMAGE	= 'PICT'
};

// MACHINE DEPENDENT CONSTANTS & PROTOTYPE



#ifdef __cplusplus
const int msg_ValueChanged		= 9001;
const int msg_DescriptorChanged	= 9002;

const int SPLIT_BAR_WIDTH = 6;



extern "C" {
#endif

VExError v_get_status_standard(struct VObjectStatus *s, int *flags, const VInfo *info);
VExError v_set_status_standard(const struct VObjectStatus *s, int flags, struct VObjectStatus *sts, VInfo *info);


#ifdef __cplusplus
}
#endif

#define VMT_STR(value) ("#" #value)
#define VMT_CONV(x)	(x)

#endif


