//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

#include	"v/v_types.h"
#include "v/v_serialized_exec.h"

extern "C" {

#include 	"machine/v_types.h"
#include	"memory_debug.h"
#include	"long_char.h"
#include	"change_endian.h"

extern LC_FONT_ENGINE_TYPE mac_font_engine_type;

typedef struct _v_gsp {
		LC_STRING_PIC * p;
		VDISPLAY * disp;
		LCF_SET * str;
		int     len;
		short 	id;
		short 	script;
		int     size;
		int     dir;
		L_CHAR mask;
} _V_GSP;

int _v_get_string_pic(_V_GSP	* v);

int
_v_get_string_pic(_V_GSP	* v)
{
int w, h;
int i, llen;
int len;
char * buf;
LCF_SET * str = v->str;
Point pt;
Rect rect;
FontInfo fontinfo;
RGBColor color;

	llen = v->len;
	if ( v->mask == LCZM_7b_TYPE ) {
		buf = (char*)d_alloc(llen+1);
		for ( i = 0 ; i < llen ; i++ )
			buf[i] = str[i].ch & 0x7f;
		buf[i] = 0;
		len = i;
	}
	else if ( v->mask == LCZM_1B_TYPE ) {
		buf = (char*)d_alloc(llen+1);
		for ( i = 0 ; i < llen ; i++ )
			buf[i] = str[i].ch;
		buf[i] = 0;
		len = i;
	}
	else if ( v->mask == LCZM_2B_TYPE ) {
		int j = 0;
		char upper;
		buf = (char*)d_alloc(llen*2+1);
		for ( i = 0 ; i < llen ; i++ ) {
			upper = (str[i].ch>>8) & 0xff;
			if ( upper )
				buf[j++] = upper;
			buf[j++] = str[i].ch & 0xff;
		}
		buf[j] = 0;
		len = j;
	}
	else if ( v->mask == LCZM_3B_TYPE ) {
		int j = 0;
		char upper;
		buf = (char*)d_alloc(llen*2+1);
		for ( i = 0 ; i < llen ; i++ ) {
			upper = (str[i].ch>>16) & 0xff;
			if ( upper ) {
				buf[j++] = upper;
				buf[j++] = (str[i].ch>>8) & 0xff;
			}
			else {
				upper = (str[i].ch>>8) & 0xff;
				if ( upper )
					buf[j++] = upper;
			}
			buf[j++] = str[i].ch & 0xff;
		}
		buf[j] = 0;
		len = j;
	}
	else
		er_panic("v_get_string_pic");
		

	TextFont(v->id);
	TextSize(v->size/10);
	GetFontInfo(&fontinfo);
	w = TextWidth(buf, 0, len);
	h = fontinfo.ascent + fontinfo.descent;
	SetRect(&rect, 0, -fontinfo.ascent, w, fontinfo.descent);
	LGWorld gworld(rect);

	gworld.BeginDrawing();
	RGBForeColor(&RGB_black);
	RGBBackColor(&RGB_white);
	EraseRect(&rect);
	TextFont(v->id);
	TextSize(v->size/10);
	MoveTo(0, 0);
	DrawText(buf, 0, len);
	GetPen(&pt);
	w = pt.h;
	unsigned char *	pic = v->p->pic = (unsigned char *)d_alloc(w*h);
	v->p->width = w;
	v->p->dir = v->dir;
	for ( int y = -fontinfo.ascent;  y < fontinfo.descent;  y++) {
		for ( int x = 0;  x < w;  x++ ) {
			GetCPixel(x, y, &color);
			pic[x+w*(y+fontinfo.ascent)] = color.red >> 8;
		}
	}
	v->p->r.tl.x = 0;
	v->p->r.tl.y = -fontinfo.ascent;
	v->p->r.br.x = w;
	v->p->r.br.y = fontinfo.descent;
	
	gworld.EndDrawing();
	return 0;
}

void
v_get_string_pic_call(
        LC_STRING_PIC * p,
        VDISPLAY * disp,
        LCF_SET * str,
        int len,
        short id,
        short script,
        int     size,
        int     dir,
        L_CHAR mask)
{
_V_GSP  v;
        v.p = p;
        v.disp = disp;
        v.str = str;
        v.len = len;
        v.id = id;
        v.script = script;
        v.size = size;
        v.dir = dir;
        v.mask = mask;
        ms_do((int(*)())_v_get_string_pic,&v,"v_get_string_pic");
}

void
v_get_string_pic(
	LC_STRING_PIC * p,
	int 		dir,
	LCF_SET *	str,
	int len)
{
VFONT * vf;
LC_FONT * f;
int size;

	f = str->font;
	size = str->size;
	if ( f->fw_list[0].fe->type != &mac_font_engine_type ) {
		memset(p,0,sizeof(*p));
		return;
	}
	vf = (VFONT*)f->fw_list[0].work;
	if ( size < 0 )
		size = vf->default_size;

	v_get_string_pic_call(p, (VDISPLAY*)f->fw_list[0].fe->work,
						str, len,
						vf->id, vf->script, size, dir,
						get_lc_mask(str[0].ch));
}

} // extern "C"