/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TREE_VIEW_M_H___
#define ___V_TREE_VIEW_M_H___

extern "C"  {

class VTreeViewImp {
	
	static void		selection_changed(
					GtkTreeSelection *treeselection,
					gpointer user_data);
	
	static void		edited_get_info(
					GObject *cell,
					gchar *path_str,
					gpointer data,
					GtkTreeStore **out_store,
					GtkTreeIter	*out_iter,
					gint *out_n,
					gint *out_column,
					VTreeNode **out_node);
	
	static void		text_edited(
					GtkCellRendererText *cell,
					gchar *path_str,
					gchar *new_text,
					gpointer data);
		
	static void		bool_edited(
					GtkCellRendererToggle *cell,
					gchar *path_str,
					gpointer data);
	
	static VInfo *	create_do(VTreeView *vobj, VTreeView::tree_set *set, int sel);
	
	static void		add(
					VInfo *info,
					int cols,
					char *types,
					VTreeNode *node,
					VTreeNode *ring);
	
	static void		remove(VInfo *info, VTreeNode *node);
	
	static void		VTreeViewImp::set(
					VInfo *info,
					int cols,
					char *types,
					VTreeNode *node,
					VTreeNode *ring);
	
	
	static VError		VTreeViewImp::add_row(
					VTreeView *view,
					VTreeNode *node,
					void *parent_key,
					void *next_key);
	static VError		remove_row(VTreeView *view, void *key);
	static VTreeNode *	get_row(const VTreeView *view, void *key);
	static VError 		set_row(VTreeView *view, VTreeNode *node,bool set_node_result);

	friend class VTreeView;
};

} // extern "C"

#endif
