/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>

#include	"serial_port.h"
#include	"memory_debug.h"
#include	"utils.h"

int	serial_port_list_ready = 0;
SERIAL_PORT_INFO *	serial_port_list = 0;


SERIAL_PORT_INFO *
lookup_serial_port()
{
FILE *p;
char buffer[80];

	if ( serial_port_list_ready )
		return serial_port_list;
	serial_port_list_ready = 1;
	
	p = popen("ls /dev/cu*", "r");
	if ( p == 0 ) {
		perror("popen");
		return 0;
	}
	while ( fgets(buffer, sizeof(buffer), p) ) {
		SERIAL_PORT_INFO *port = d_alloc(sizeof(SERIAL_PORT_INFO));
		port->next = serial_port_list;
		serial_port_list = port;
		
		buffer[strlen(buffer)-1] = 0;
		port->info = port->name = copy_str(buffer);
	}
	pclose(p);
	return serial_port_list;
}

