/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VStaticText.h"
#include "VApplication.h"
#include "vobject_main.h"
#include "vwin_control.h"


static HWND CreateStaticWindow(int style, HWND hwnd, int id){
	return ::CreateWindowEx(
		0, 
		"STATIC",
		"STATIC",
		style,
		0,
		0,
		0,
		0,
		hwnd,
		(HMENU)id,
		theApp->get_instance(),
		NULL);
}

VExError 
VStaticText::create_do(const VObjectStatus* s, int flags, VObject *parent, void * arg)
{
	
	DWORD style=WS_CHILD | SS_CENTER;
	if(!s->enabled){
		style |= WS_DISABLED;
	}
	if(s->visible){
		style |= WS_VISIBLE;
	}
	
	/* find container window that will own this button.*/
	VContainerInfo *container_info = VInfo::get_container_info(parent);
	int id = container_info->get_next_control_id();
	HWND hwnd = v_serialized_exec_func(CreateStaticWindow, style, container_info->get_hwnd(), id);
	info = new VInfo(this, hwnd, id);
	
	return parent->add_child_do(this);
}

void
VStaticText::destroy_do(VObject *parent)
{
	parent->remove_child_do(this);
	if(info){
		v_serialized_exec_sub(::DestroyWindow, info->get_hwnd());
		delete info;
		info = NULL;
	}
	sts.parent->redraw();
}

VStaticText::~VStaticText()
{
}

VExError
VStaticText::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = VObject::get_status(s,flags);
	win_control_default_get_status(info->get_hwnd(), s, flags, &err);
	V_OP_END
	return err;
};

VExError
VStaticText::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VSize last_size = sts.min_size;
	VExError err = VObject::set_status(s,flags);
	HWND hwnd = info->get_hwnd();
	if ( flags & (VSF_POSITION | VSF_SIZE) ) {
		VObjectStatus s2 = *s;
		if ( flags & VSF_SIZE ) {
			s2.size.h = sts.min_size.h;
			if ( flags & VSF_POSITION )
				s2.position.y += (s->size.h - sts.min_size.h) / 2;
		}
		else if ( flags & VSF_POSITION )
			s2.position.y += (sts.size.h - sts.min_size.h) / 2;
		win_control_default_set_status(hwnd, &s2, flags&~VSF_DESC, &err);
	}
	else
		win_control_default_set_status(hwnd, s, flags&~VSF_DESC, &err);

	if ( flags & VSF_CALC_MIN ) {
		// min is calculated when desc is set
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	
	if( (flags & VSF_DESC) && sts.vert_desc){
		LONG style = ::GetWindowLong(hwnd, GWL_STYLE);
		v_serialized_exec_sub(::SetWindowLong, hwnd, GWL_STYLE, style|BS_MULTILINE);
	}
	if ( flags & (VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS) ) {
		v_set_descriptor(info, sts.descriptor, sts.ws, sts.fsize, sts.vert_desc, &sts.min_size);
		err.subcode1 &= ~(VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS);
	}

	if ( flags & VSF_VISIBLE ) {
		if ( s->visible != (::IsWindowVisible(info->get_hwnd())==TRUE) ){
			v_serialized_exec_sub(::ShowWindow, hwnd, s->visible ? SW_SHOW : SW_HIDE);
		}
		err.subcode1 &= ~VSF_VISIBLE;
	}

	V_OP_END
	
	if ( (flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE)) ||
		 (flags & (VSF_DESC | VSF_WS | VSF_FSIZE)) &&
			(sts.min_size.w != last_size.w ||
			 sts.min_size.h != last_size.h) )
		VLayout::mark(this);
	return err;
}

void
VStaticText::redraw(VRect *rect) const
{
	if ( ! info )
		return;
	_V_OP_START_VOID
	win_redraw(info->get_hwnd(), rect);
	V_OP_END
}
