/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___FT2ENGINE_H___
#define ___FT2ENGINE_H___

#include <ft2build.h>
#include <freetype/freetype.h>
#include <freetype/ttnameid.h>
#include <freetype/ftbdf.h>
#include <freetype/tttables.h>
#include FT_FREETYPE_H


#include "long_char.h"

extern LC_FONT_ENGINE ft2_font_engine;


typedef struct ft2_encode_info {
	int		driver_type;
#define DT_FT2		1
#define DT_BDF		2
#define DT_WINFONT	3
#define DT_MACFONT	4

	L_CHAR		lc_lcz[2];
	L_CHAR		lc_mask[2];
	L_CHAR		from;
	L_CHAR		to;
	char *		coverage;
} FT2_ENCODE_INFO;

typedef struct ft2_fontrec {
	FT_Face			work_face;
	FT2_ENCODE_INFO *	encode_info;
	/* this list equal to work_face->num_charmaps */
	char *			path;
	int			face;
	L_CHAR *		family;
	L_CHAR *		style;
	int			size_len;
	int *			sizes;

	struct ft2_fontrec *	all_next;
	struct ft2_fontrec *	family_next;
	unsigned		active:1;
} FT2_FONTREC;

typedef struct ft2_font_work {
	unsigned	type:1;
#define FWT_ALL_LIST	0
#define FWT_FAMILY_LIST	1
	unsigned	scalable:1;
	FT2_FONTREC *	fr;
} FT2_FONT_WORK;


void ft2engine_init();

int ft2_get_font();
void ft2_get_string_pic();
int ft2_font_coverage();


#endif
