/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___V_XL_EDIT_LINE_H___
#define ___V_XL_EDIT_LINE_H___


extern "C" {
}

#include	"v/VMacro.h"
#include	"v/VEditText.h"
#include	"v/VTreeView.h"
#include	"v/VButton.h"
#include	"v/VStaticText.h"

typedef struct VxlEditLineStatus {
	unsigned		items:4;
#define VEL_ITEM_EDIT_TEXT	1
#define VEL_ITEM_EDIT_TEXT_2	2
#define VEL_ITEM_TREE_VIEW	4
#define VEL_ITEM_FILE_INPUT	8
	unsigned		writing_direction:4;
/*
#define VSD_V_R2L	1
#define VSD_V_L2R	2
#define VSD_H_L2R	4
#define VSD_H_R2L	8
*/
	unsigned		file_convert:4;
#define VEL_FC_NONE		0
#define VEL_FC_URL		1
#define VEL_FC_DIR		2
	L_CHAR **		data;
	L_CHAR *		tree_view_title;
	L_CHAR *		add_descriptor;
	L_CHAR *		del_descriptor;
	L_CHAR *		bro_descriptor;
	L_CHAR *		ok_descriptor;

	short			max_len;
	short			min_len;
	short			col_len;
} VxlEditLineStatus;

#define VSF_EL_ITEMS			(1<<0)
#define VSF_EL_WRITING_DIRECTION	(1<<1)
#define VSF_EL_FILE_CONVERT		(1<<2)
#define VSF_EL_DATA			(1<<3)
#define VSF_EL_ADD_DESCRIPTOR		(1<<4)
#define VSF_EL_DEL_DESCRIPTOR		(1<<5)
#define VSF_EL_BRO_DESCRIPTOR		(1<<6)
#define VSF_EL_OK_DESCRIPTOR		(1<<7)
#define VSF_EL_EDIT_TEXT_MAX_LEN	(1<<8)
#define VSF_EL_EDIT_TEXT_MIN_LEN	(1<<9)
#define VSF_EL_EDIT_TEXT_COL_LEN	(1<<10)

typedef struct obj_arg {
	VEditText *		edit_text;
	VTreeView *		tree_view;
	VObject *		file_select;
	VPushButton *		add_btn;
	VPushButton *		del_btn;
	VPushButton *		bro_btn;
	VPushButton *		ok_btn;
	VStaticText *		static_text;
#define OA_MAX_GRUE	2
	VObject *		grue[OA_MAX_GRUE];
	int			max_node_key;
} OBJ_ARG;

class VxlEditLine : public VMacro
{
  public:
	enum { object_type = VO_XTXT };

	virtual unsigned	get_type() const { return object_type; }

	static VxlEditLine* create(const VObjectStatus *s, int flags,void * arg= 0, VExError* err=0) {
		return static_cast<VxlEditLine*>(
			create_tmp(internal_new, object_type, s, flags, err, arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;

	virtual VExError get_xlel_status(
				VxlEditLineStatus *,
				int flags) const;
	virtual VExError set_xlel_status(
				const VxlEditLineStatus *,
				int flags);

	void	_push_add_btn();
	void	_push_del_btn();
	void	_push_bro_btn(char*);
	V_CALLBACK_D(_ok_btn_handler);

  protected:

  	virtual ~VxlEditLine();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject *);
	virtual void	destroy_do_out_of_lock(VObject*);

	VxlEditLineStatus		e_sts;
	OBJ_ARG			_obj_arg;
	int			create_flags;

  private:
	static VObject *internal_new(){
	VxlEditLine * ret;
		ret = new VxlEditLine();
		return ret;
	}
};




#endif

