/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"long_char.h"


VWSConvertList *
search_convert_list(VWritingStyle * ws,int size)
{
VWSConvertList * ret;
	for ( ret = ws->conv_tbl ; ret ; ret = ret->next )
		if ( ret->size == size )
			return ret;
	return 0;
}


VCharFontList *
lc2cfl(VWritingStyle * ws,int size,L_CHAR * str)
{
int len;
int i,j;
WRITABLE_CODE_TABLE * t;
VWSConvertList * cl;
VCharFontList * ret;
VCharFontList ** flp, * cur;
int data_size;
	cl = search_convert_list(ws,size);
	if ( cl == 0 )
		return 0;

	len = l_strlen(str);

	ret = 0;
	flp = &ret;
	for ( i = 0 ; i < len ; ) {
		t = get_wct(cl->table,str[i]);
		if ( t ) {
			for ( j = i ; j < len &&
				(str[j]&t->mask) == t->lcz ; j ++ );
			data_size = j - i;
			cur = d_alloc(sizeof(*cur),346);
			cur->str = d_alloc(sizeof(L_CHAR)*(data_size+1),346);
			memcpy(cur->str,&str[i],sizeof(L_CHAR)*data_size);
			cur->str[data_size] = 0;
			i = j;
			cur->font = (VFontList*)t->work;
			cur->next = 0;
		}
		else {
			cur = d_alloc(sizeof(*cur),46);
			cur->str = 0;
			cur->font = 0;
			cur->next = 0;
			i ++;
		}
		*flp = cur;
		flp = &cur->next;
	}
	return ret;
}


