/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef DATABASE_QUALITY_TABLE_H____
#define DATABASE_QUALITY_TABLE_H____

#include "vpf_types.h"

typedef struct {
	LONG id;
	char vpf_level[9];
	char vpf_level_name[9];
	char *feature_complete;
	char *attrib_complete;
	char *logical_consist;
	char edition_num[9];
	VPF_DATE creation_date;
	VPF_DATE revision_date;
	char *spec_name;
	VPF_DATE spec_date;
	VPF_DATE earliest_source;
	VPF_DATE latest_source;
	char *quant_att_acc;
	char *qual_att_acc;
	char *collection_spec;
	char source_file_name[13];
	char *abs_horiz_acc;
	char abs_horiz_units[21];
	char *abs_vert_acc;
	char abs_vert_units[21];
	char *rel_horiz_acc;
	char rel_horiz_units[21];
	char *rel_vert_acc;
	char rel_vert_units[21];
	char *comments;
}DATA_QUALITY_RECORD;

void data_quality_record_delete(DATA_QUALITY_RECORD *tbl);
BOOL data_quality_record_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);

#endif

