/**********************************************************************
 
	Copyright (C) 2006 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"progressive.h"
#include	"memory_debug.h"
#include	"utils.h"
#include	"task.h"

#define P_RATES_AVG_RATE	0.1

PROGRESSIVE *
_new_progressive(int stages)
{
PROGRESSIVE * ret;
int i;
	ret = d_alloc(sizeof(*ret));
	ret->stages_nos = stages;
	ret->stages = d_alloc(sizeof(P_STAGE)*stages);
	ret->estimate_total_time = -1;
	ret->est_time = 0;
	memset(ret->stages,0,sizeof(P_STAGE)*stages);
	for ( i = 0 ; i < stages ; i ++ )
		ret->stages[i].rate_estimate_total_time = -1;
	return ret;
}

void
_free_progressive(PROGRESSIVE * p)
{
int i;
P_STAGE * s;
	for ( i = 0 ; i < p->stages_nos ; i ++ ) {
		s = &p->stages[i];
		if ( s->prediction_rates )
			d_f_ree(s->prediction_rates);
	}
	d_f_ree(p->stages);
	d_f_ree(p);
}

void
_set_prediction_rates(PROGRESSIVE * p,double * rates)
{
int i,j,r;
P_STAGE * s;
	r = 0;
	for ( i = 0 ; i < p->stages_nos ; i ++ ) {
		s = &p->stages[i];
		if ( i > 0 && s->prediction_rates == 0 )
			s->prediction_rates = d_alloc(sizeof(double)*(i-1));
		for ( j = 0 ; j < i ; j ++ )
			s->prediction_rates[j] = rates[r++];
	}
}


void
_get_prediction_rates(PROGRESSIVE * p,double * rates)
{
int i,j,r;
P_STAGE * s;
double tim;
double new_rate;
	r = 0;
	for ( i = 0 ; i < p->stages_nos ; i ++ ) {
		s = &p->stages[i];
		for ( j = 0 ; j < i ; j ++ ) {
			tim = p->stages[j].estimate_total_time;
			if ( tim == 0 )
				continue;
			new_rate = p->stages[i].estimate_total_time / tim;
			rates[r++] = p->stages[i].prediction_rates[j] * (1-P_RATES_AVG_RATE)
						+ new_rate * P_RATES_AVG_RATE;
		}
	}
}

void
_progressive_estimation(PROGRESSIVE * p,int force)
{
int i,j;
P_STAGE * s;
double est;
int cnt;
double total;
INTEGER64 now;
	now = get_xltime();
	if ( (force == 0) && (p->est_time == now) )
		return;
	total = 0;
	for ( i = 0 ; i < p->stages_nos ; i ++ ) {
		s = &p->stages[i];
		if ( s->finished == 0 ) {
			if ( i == 0 ) {
				s->estimate_total_time = -1;
			}
			else {
				est = 0;
				cnt = 0;
				for ( j = 0 ; j < i ; j ++ ) {
					if ( s->prediction_rates[j] < 0 )
						continue;
					if ( p->stages[j].estimate_total_time < 0 )
						continue;
					est += s->prediction_rates[j] * p->stages[j].estimate_total_time;
				}
				if ( cnt == 0 )
					s->rate_estimate_total_time = -1;
				else	s->rate_estimate_total_time = est / cnt;
				s->estimate_total_time = s->rate_estimate_total_time;
			}
		}
		else if ( s->finished < s->total ) {
			if ( s->rate_estimate_total_time < 0 )
				s->estimate_total_time = (now - s->start_time) * s->total / s->finished;
			else	s->estimate_total_time = (now - s->start_time)
					+ s->rate_estimate_total_time * (1 - s->finished / s->total );
		}
		else {
			s->estimate_total_time = now - s->start_time;
		}
		if ( total < 0 )
			continue;
		if ( s->estimate_total_time < 0 ) {
			total = -1;
			continue;
		}
		total += s->estimate_total_time;
	}
	p->estimate_total_time = total;
	p->est_time = now;
}


int
_start_progressive(PROGRESSIVE * p,int stage,double total)
{
int i;
P_STAGE * s;
	for ( i = 0 ; i < stage ; i ++ ) {
		s = &p->stages[i];
		if ( s->finished == 0 )
			return -1;
		if ( s->finished < s->total )
			return -2;
	}
	s = &p->stages[stage];
	if ( s->start_time )
		return -3;
	s->total = total;
	s->finished = 0;
	s->start_time = get_xltime();
	_progressive_estimation(p,1);
	return 0;
}

int
_set_progressive(PROGRESSIVE * p,int stage,double finished)
{
P_STAGE * s;
	s = &p->stages[stage];
	if ( s->start_time == 0 )
		return -1;
	s->finished = finished;
	if ( s->finished == s->total )
		_progressive_estimation(p,1);
	else	_progressive_estimation(p,0);
	return 0;
}



