/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "v/VMacro.h"
#include "v/v.h"

extern "C" {

#include "memory_debug.h"
#include "xldir.h"

void init_VMacro();
void init_tempolary_files();


void
init_tempolary_files()
{
char * p;
char * p2;
DIR_LIST * d1,*d2;
	p = get_preference_path();
	p2 = (char*)d_alloc(strlen(p)+100);
	sprintf(p2,"%stmp/*",p);
	d1 = get_dir(p2,0,0,0,DLF_FILE);
	for ( d2 = d1 ; d2 ; d2 = d2->next ) {
		u_unlink(d2->name);
	}
	d_f_ree(p2);
}



int
_vobject_init_xl(int * argc,char *** argv,INIT_FUNC_LIST * flist)
{
	init_tempolary_files();
	init_VMacro();
	init_VxlTreeView();
	if ( flist )
		(*flist->func)(argc,argv,flist->next);
	return 0;
}

int
vobject_init_xl(int * argc,char *** argv)
{
INIT_FUNC_LIST flist;
	flist.next = 0;
	flist.func = _vobject_init_xl;
	flist.work = 0;
	return _vobject_init(argc,argv,&flist);
}


} // extern "C"

