/**********************************************************************
 
	Copyright (C) 2004
		Hirohisa MORI <joshua@nichibun.ac.jp>
		Tomohito Nakajima <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_Mkdir();

void
init_Mkdir(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Mkdir"),
		get_func_prim(xl_Mkdir, FO_APPLICATIVE, 0, 2, 2));
}

XL_SEXP *
xl_Mkdir(XLISP_ENV * env,XL_SEXP * s, XLISP_ENV * arg_env, XL_SYM_FIELD * sf)
{
XL_SEXP * dir_name;
char *path;
int mode;

	dir_name = get_el(s,1);
	if(get_type(dir_name) != XLT_STRING){
		goto type_missmatch;
	}
	mode = 0755;
	for( ;sf;sf = sf->next){
		if ( l_strcmp(sf->name,l_string(std_cm,"mode")) ){
			mode = atoi(n_string(std_cm, sf->data));
		}
	}
	path = n_string(std_cm, dir_name->string.data);
	return get_integer(u_mkdir(path, mode), 0);
	
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Mkdir"),
		List(n_get_string("directory name is type missmatch"),
			-1));
}

