/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"memory_routine.h"
#include	"cal.h"
#include	"xlerror.h"

#define GET_TERM_LEN		10

void xlcal_gc(XL_CAL * c);
XL_SEXP *
get_cal_component(int * status,XL_CAL * c);
void gc_tick_notin_tick();


int
xlcal_read(L_CHAR * ch,XL_CAL * c)
{
int er;
char cc;
	if ( c->push_chr_flag ) {
		*ch = c->push_chr;
		c->push_chr_flag = 0;
		return 1;
	}
	for ( ; ; ) {
		if ( c->bptr >= c->buffer_len ) {
			er = s_read(c->st,&c->buffer[0],XL_CAL_BUFFER_SIZE);
			if ( er <= 0 )
				return er;
			c->buffer_len = er;
			c->bptr = 0;
		}
		cc = c->buffer[c->bptr++];
		if ( (*c->cm->to_internal)
				(ch,c->cm_work,cc) ) {

			return 1;
		}
	}
}

L_CHAR *
get_term(int * ret_char,XL_CAL * c,char * term_char)
{
L_CHAR * ret;
int ptr,len;
L_CHAR ch;
int er;
int i;
	ret = d_alloc(sizeof(L_CHAR)*GET_TERM_LEN);
	len = GET_TERM_LEN;
	ptr = 0;
	for ( ; ; ) {
		if ( ptr >= len ) {
			ret = d_re_alloc(ret,sizeof(L_CHAR)*len*2);
			len = len * 2;
		}
		er = xlcal_read(&ch,c);
		if ( er < 0 ) {
			d_f_ree(ret);
			*ret_char = er;
			return 0;
		}
		if ( er == 0 ) {
			*ret_char = -1;
			return 0;
		}
		if ( ch != '\\' ) {
			for ( i = 0 ; term_char[i] ; i ++ ) {
				if ( ch == term_char[i] )
					break;
			}
			if ( term_char[i] )
				break;
		}
		else {
			er = xlcal_read(&ch,c);
			if ( er < 0 ) {
				d_f_ree(ret);
				*ret_char = er;
				return 0;
			}
			if ( er == 0 ) {
				*ret_char = -1;
				return 0;
			}
			switch ( ch ) {
			case 'n':
				ch = '\n';
				break;
			case 't':
				ch = '\t';
				break;
			}
		}
		ret[ptr++] = ch;
	}
	ret = d_re_alloc(ret,sizeof(L_CHAR)*(ptr+1));
	ret[ptr] = 0;
	*ret_char = i;
	return ret;
}

void
xlcal_push(XL_CAL * c,L_CHAR chr)
{
	if ( c->push_chr_flag )
		er_panic("xlcal_push");
	c->push_chr = chr;
	c->push_chr_flag = 1;
}

L_CHAR *
marge_term(L_CHAR * t1,L_CHAR * t2)
{
int len1,len2;
	len1 = l_strlen(t1);
	len2 = l_strlen(t2);
	t1 = d_re_alloc(t1,sizeof(L_CHAR)*(len1+len2+1));
	memcpy(&t1[len1],t2,sizeof(L_CHAR)*len2);
	t1[len1+len2] = 0;
	return t1;
}

XL_SEXP *
get_cal_line(int * status,XL_CAL * c)
{
L_CHAR * term,*term2;
int stop_char;
XL_SEXP * sym;
L_CHAR * attr_name;
L_CHAR chr;
	term = get_term(&stop_char,c,":;\r\n");
	if ( stop_char < 0 || stop_char >= 2 ) {
		if ( term )
			d_f_ree(term);
		return 0;
	}
	sym = 0;
	if ( l_strcmp(term,l_string(std_cm,"BEGIN")) == 0 ) {
		if ( stop_char != 0 )
			goto component_error_begin;
		*status = CS_COMPONENT_BEGIN;
	}
	else if ( l_strcmp(term,l_string(std_cm,"END")) == 0 ) {
		if ( stop_char != 0 )
			goto component_error_end;
		*status = CS_COMPONENT_END;
	}
	else {
		*status = CS_PROPERTY;
		sym = get_symbol(term);
	}
	d_f_ree(term);
	
	if ( stop_char == 1 ) {
		for ( ; ; ) {
			term = get_term(&stop_char,c,"=\r\n");
			switch ( stop_char ) {
			case 0:
				attr_name = term;
				break;
			default:
				if ( term )
					d_f_ree(term);
				return List(sym,-1);
			}
			term = get_term(&stop_char,c,";:\r\n");
			switch ( stop_char ) {
			case 0:
				set_attribute(sym,attr_name,term);
				d_f_ree(attr_name);
				d_f_ree(term);
				break;
			case 1:
				set_attribute(sym,attr_name,term);
				d_f_ree(attr_name);
				d_f_ree(term);
				goto next1;
			case 2:
			case 3:
				set_attribute(sym,attr_name,term);
				d_f_ree(attr_name);
				d_f_ree(term);
				return List(sym,-1);
			default:
				if ( term )
					d_f_ree(term);
				return List(sym,-1);
			}
		}
	}
next1:
	term = get_term(&stop_char,c,"\r\n");
	for ( ; ; ) {
		if ( xlcal_read(&chr,c) <= 0 )
			break;
		switch ( chr ) {
		case '\r':
		case '\n':
			continue;
		case ' ':
			term2 = get_term(&stop_char,c,"\r\n");
			term = marge_term(term,term2);
			d_f_ree(term2);
			continue;
		default:
			xlcal_push(c,chr);
			break;
		}
		break;
	}
	if ( *status == CS_PROPERTY ) {
		sym = List(sym,get_string(term),-1);
	}
	else {
		sym = get_symbol(term);
	}
	d_f_ree(term);
	return sym;
component_error_begin:
	return get_error(
		0,
		0,
		XLE_PROTO_INV_FILE_TYPE,
		l_string(std_cm,"iCalendar parser (BEGIN with parameter)"),
		0);
component_error_end:
	return get_error(
		0,
		0,
		XLE_PROTO_INV_FILE_TYPE,
		l_string(std_cm,"iCalendar parser (END with parameter)"),
		0);
}


XL_SEXP *
xlcal_load(XL_SEXP * s)
{
XL_CAL * c;
XL_CAL_STACK * stk;
XL_SEXP * ld,*ss;
int status;

	c = (XL_CAL*)s->delay.d.func;
	gc_push(c,xlcal_gc,"");
	stk = c->stack;
	for ( ; c->stack->delay != s ; )
		xlcal_load(c->stack->delay);
	ld = get_cal_component(&status,c);
	if ( status == CS_COMPONENT_END ) {
		set_sexp_inh(0,XLT_NULL,s,s);
		c->stack = c->stack->next;
		if ( c->stack == 0 ) {
			(*c->cm->close)(0,c->cm_work);
			s_close(c->st);
		}
	}
	else {
		set_sexp_inh(0,XLT_PAIR,s,s);
		s->pair.car = ld;
		s->pair.cdr = ss = init_delay_func(&c->h);
		stk->delay = ss;
	}
	gc_pop(0,0);
	return s;
}

void
gc_xl_cal_stack(XL_CAL_STACK * st)
{
	if ( st == 0 )
		return;
	if ( TEST_AND_SET(st) )
		return;
	gc_gb_sexp(st->delay);
	for ( st = st->next ; st ; st = st->next )
		gc_xl_cal_stack(st);
}

void
xlcal_gc(XL_CAL * c)
{
	if ( c == 0 )
		return;
	if ( TEST_AND_SET(c) )
		return;
	gc_xl_cal_stack(c->stack);
	return;
}

XL_SEXP *
get_cal_component(int * status,XL_CAL * c)
{
XL_SEXP * ld,*ss;
XL_CAL_STACK * st;

	ld = get_cal_line(status,c);
	if ( get_type(ld) == XLT_ERROR ) {
		(*c->cm->close)(0,c->cm_work);
		s_close(c->st);
		return ld;
	}
	switch ( *status ) {
	case CS_COMPONENT_BEGIN:
		ss = init_delay_func(&c->h);
		st = mmalloc(sizeof(*st),gc_xl_cal_stack);
		st->delay = ss;
		st->next = c->stack;
		c->stack = st;
		return cons(ld,ss);
	case CS_PROPERTY:
		if ( c->stack == 0 ) {
			(*c->cm->close)(0,c->cm_work);
			s_close(c->st);
		}
		return ld;
	case CS_COMPONENT_END:
		if ( c->stack == 0 ) {
			(*c->cm->close)(0,c->cm_work);
			s_close(c->st);
		}
		return 0;
	default:
		(*c->cm->close)(0,c->cm_work);
		s_close(c->st);
		return get_error(
			0,
			0,
			XLE_PROTO_INV_FILE_TYPE,
			l_string(std_cm,"iCalendar parser (invalid property)"),
			get_integer(*status,0));
	}

}

XL_SEXP *
get_cal(STREAM * st,CODE_METHOD * cm)
{
XL_CAL * c;
int status;
XL_SEXP * ret;
	gc_push(0,0,"");
	c = mmalloc(sizeof(*c),xlcal_gc);
	memset(c,0,sizeof(*c));
	c->st = st;
	if ( cm )
		c->cm = cm;
	else	c->cm = &utf8_cm;
	c->cm_work = (*c->cm->open)();
	c->buffer_len = c->bptr = 0;
	c->h.func = xlcal_load;
	c->h.gc_func = xlcal_gc;
	c->h.check_func = 0;
	c->stack = 0;

	ret = get_cal_component(&status,c);
	
	gc_pop(ret,gc_gb_sexp);
	return ret;
}



