/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"xl.h"
#include	"memory_routine.h"
#include	"mlong_char.h"

unsigned int time_set_env;

void gc_element();
SEM gb_env_lock;

unsigned int
hash_key(L_CHAR * n,int hash_size)
{
unsigned int key;
	key = 0;
	for ( ; *n ; n ++ )
		key += *n;
	return key%hash_size;
}

void
re_hash(XLISP_ENV * e,int new_size)
{
ELEMENT ** ee,** ff;
ELEMENT * p1;
int i,key;
int sz;

	ee = e->e.hash_ptr;
	sz = e->e.hash_ptr_size;
	ff = mmalloc(sizeof(ELEMENT*)*new_size,gc_text);
	lock_mem();
	for ( i = 0 ; i < sz ; i ++ ) {
		for ( ; ; ) {
			p1 = ee[i];
			if ( p1 == 0 )
				break;
			ee[i] = p1->next;
			key = hash_key(p1->sym,new_size);
			p1->next = ff[key];
			ff[key] = p1;
		}
	}
	e->e.hash_ptr_size = new_size;
	e->e.hash_ptr = ff;
	unlock_mem();
}

void
set_env(XLISP_ENV * env,L_CHAR * sym,XL_SEXP * s)
{
int key;
ELEMENT * e;


	for ( ; env->type != GBET_ENV ; )
		env = env->p.env[1];
	if ( env == 0 )
		return;
	key = hash_key(sym,env->e.hash_ptr_size);

	lock_task(gb_env_lock); 
	for ( e = env->e.hash_ptr[key] ; e ; e = e->next )
		if ( l_strcmp(e->sym,sym) == 0 )
			goto next;
	e = mmalloc(sizeof(*e),gc_element);
	e->next = env->e.hash_ptr[key];
	env->e.hash_ptr[key] = e;
	env->e.hash_element_nos ++;
next:
	e->sym = ll_copy_mstr(sym);
	e->data = s;
	unlock_task(gb_env_lock,"set_env"); 

	switch ( env->e.hash_ptr_size ) {
	case ENV_HASH_SIZE_1:
		if ( env->e.hash_element_nos >= ENV_HASH_SIZE_2/2 ) {
			re_hash(env,ENV_HASH_SIZE_2);
		}
		break;
	}
}

void
set_default_env(XLISP_ENV * env,XL_SEXP * s)
{
ELEMENT * e;
	for ( ; env->type != GBET_ENV ; )
		env = env->p.env[1];
	if ( env == 0 )
		return;
	e = mmalloc(sizeof(*e),gc_element);
	e->next = 0;
	e->sym = 0;
	e->data = s;
	lock_task(gb_env_lock); 
	env->e.default_sym = e;
	unlock_task(gb_env_lock,"set_default_env"); 
}

