/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifdef VA2
#include	<varargs.h>
#else
#include	<stdarg.h>
#endif
#include	"xl.h"
#include	"memory_debug.h"

char *sc_add_str(char * str,char * s1);

char *
sc_add_str(char * str,char * s1)
{
int len1,len2;
	if ( str ) {
		len2 = strlen(s1);
		len1 = strlen(str);
		str = d_re_alloc(str,len1+len2+1);
		strcpy(&str[len1],s1);
		return str;
	}
	else {
		return copy_str(s1);
	}
}


XL_SEXP *
sexp_commands(
	CODE_METHOD * cm,...)
{
va_list p;
char * str;
char * _s;
STREAM * st;
XL_SEXP* ret, * r;
	str = 0;
#ifdef VA2
	va_start(p);
#else
	va_start(p,cm);
#endif
	for ( ; ; ) {
		_s = va_arg(p,char*);
		if ( _s == 0 )
			break;
		str = sc_add_str(str,_s);
	}
	va_end(p);

	st = s_open_string_read(str,cm,strlen(str),1);
	d_f_ree(str);
	ret = init_parse(st,
		l_string(std_cm,"sexp_commands"),
		l_string(std_cm,"sexp_commands"));
	for ( r = ret ; get_type(r) == XLT_PAIR ; r = cdr(r) );
	r = list_error(ret);
	if ( get_type(r) == XLT_ERROR )
		return r;
	return ret;
}


char *
sxc_int(INTEGER64 d)
{
char * ret;
	ret = d_alloc(100);
	sprintf(ret, I64_FORMAT, d);
	set_buffer(ret);
	return ret;
}

char *
sxc_float(double d)
{
char * ret;
	ret = d_alloc(100);
	sprintf(ret,"%f",d);
	set_buffer(ret);
	return ret;
}

