/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VProgressBar.h"

#include <LProgressBar.h>
#include "machine/v_types.h"


VExError
VProgressBar::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	sts.min_size = (VSize){40,10};
	
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	LProgressBar *v = new LProgressBar(paneInfo, 0, 0, 0, 100);
	v->FinishCreate();
	info = v;
	return nmp->add_child_do(this);
}

void
VProgressBar::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	delete info;
	nmp->redraw();
}

VProgressBar::~VProgressBar()
{
}


VExError
VProgressBar::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VProgressBar::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	
	if ( flags & VSF_VALUE ) {
		if ( s->value < 0 )
			((LProgressBar*)info)->SetIndeterminateFlag(true);
		else {
			((LProgressBar*)info)->SetIndeterminateFlag(false);
			info->SetValue(s->value);
		}
		err.subcode1 &= ~VSF_VALUE;
	}

	V_OP_END

	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

void
VProgressBar::redraw(VRect* rect) const
{
	_V_OP_START()
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	V_OP_END
}
