/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include "init.h"
#include "change_endian.h"
#include "gbf.h"
#include "utils.h"


void
v_loop_init()
{
}

int
main(int argc, char** argv)
{
int l;
	if ( argc != 3 ) {
		fprintf(stderr,"usage: %s font_size dest_path\n",argv[0]);
		exit(1);
	}
	
	check_endian();
	init_task(INI_DONTWAITCHI); 
	init_msequence();
	init_longchar();
	init_utils();
	
	l = strlen(argv[2])-1;
	if ( argv[2][l] == '/' )
		argv[2][l] = 0;
	gbf_load(argv[2]);
	
	return 0;
}


/*
#include "v.h"

extern int fontsize;
extern char * display_key;
int
main(int argc, char** argv)
{
VDISPLAY * d;
VERROR er;
V_STRING_PIC p;
int x,y,i;
	check_endian();
	init_task(INI_DONTWAITCHI); 
	init_msequence();
	init_longchar();
	init_stream();
	init_utils();

	fontsize = atoi(argv[1]);
	display_key = argv[2];
	d = gbf_open_disp(&er);

	gbf_get_string_pic(&p, d, l_string(std_cm,"noname;"),24,2);
	printf("%d,%d - %d,%d  w=%d\n", p.r.tl.x, p.r.tl.y, p.r.br.x, p.r.br.y, p.width);
	
	i = 0;
	for ( y = p.r.tl.y ; y < p.r.br.y ; y++ ) {
		for ( x = p.r.tl.x ; x < p.r.br.x ; x++ ) {
			printf("%c", p.pic[i++]?' ':'o');
		}
		printf("\n");
	}
	
	return 0;
}
*/
