/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <termios.h>
#include <unistd.h>

#include "utils.h"
#include"stream.h"
#include "serial_port.h"

STREAM *	s_open_file_descripter();


STREAM *
open_serial_port(SERIAL_PORT_INFO *info, int speed)
{
 struct termios ios;
int fid;
	
	fid = open(info->info, O_RDWR);
	if ( fid < 0 ) {
		perror("open");
		er_panic("open_serial_port");
	}
	tcgetattr(fid, &ios);
	cfsetispeed(&ios, speed);
	cfsetospeed(&ios, speed);
	ios.c_cflag |= CLOCAL;
	tcsetattr(fid, TCSAFLUSH, &ios);
	return s_open_file_descripter(fid, &s_file_table);
}
