/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<sys/types.h>
#include	<time.h>
#include	"memory_debug.h"
#include	"utils.h"


char month_table[12][4] = {
"Jan",
"Feb",
"Mar",
"Apr",
"May",
"Jun",
"Jul",
"Aug",
"Sep",
"Oct",
"Nov",
"Dec"
};

int
get_xltime()
{
	return time(0)-UTC_00_00_00_01_01_2001;
}

char *
get_xltime_str(unsigned int t,int format)
{
time_t tt;
char * a;
char day[10];
char month[10];
int date;
char tim[10];
int year;
int m;
char ret[20];
	switch ( format ) { 
	case TFMT_UNIX:
		tt = t + UTC_00_00_00_01_01_2001;
		return copy_str(ctime(&tt));
	case TFMT_W3C_DTF:
		tt = t + UTC_00_00_00_01_01_2001;
		a = copy_str(ctime(&tt));
		sscanf(a,"%s %s %i %s %i",
			day,month,&date,tim,&year);
		d_f_ree(a);
		for ( m = 0 ; m < 12 ; m ++ )
			if ( strcmp(month,month_table[m]) == 0 ) {
				m ++;
				break;
			}
		if ( m == 13 )
			er_panic("get_xltime_str(1)");
		sprintf(ret,"%04i-%02i-%02i",year,m,date);
		return copy_str(ret);
	default:
		return 0;
	}
}


