/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VSlider.h"
#include "machine/v_object.h"

inline int
slider_value(gdouble v, int min, int step)
{
    int vi = (int)v;
    return vi - (vi-min+step/2) % step + step/2;
}

extern "C" gchar *
v_slider_format_value(GtkScale *scale, gdouble arg, gpointer user_data)
{
    VSlider *sld = (VSlider*)user_data;
    return g_strdup_printf("%d", slider_value(arg,
            sld->get_range_min(), sld->get_range_step()));
}

extern "C" VInfo *
v_slider_create_do(VSlider *obj, int min, int max, int step)
{
    VInfo *info;
    GtkAdjustment *adj = (GtkAdjustment*)gtk_adjustment_new(
            (gdouble)min, (gdouble)min, (gdouble)max+step,
            (gdouble)step, (gdouble)step*5, (gdouble)step);
    info = gtk_hscale_new(adj);
    gtk_scale_set_digits(GTK_SCALE(info), 0);
    g_object_ref(info);
    g_signal_connect(info, "value-changed", G_CALLBACK(::value_changed), obj);
    g_signal_connect(info, "format-value", G_CALLBACK(::v_slider_format_value), obj);
    return info;
}

VExError
VSlider::create_do(const VObjectStatus* s, int flags, 
			VObject * nmp,void * arg)
{

	min = ((range_set*)arg)->min;
	max = ((range_set*)arg)->max;
	step = ((range_set*)arg)->step;

	info = v_serialized_exec_func(v_slider_create_do, this, min, max, step);

	return return_create_do(this,nmp,&sts,s,flags);
}

void
VSlider::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, info);
}

VSlider::~VSlider()
{
}

VExError
VSlider::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	
	if ( flags & VSF_VALUE ) {
		s->value = slider_value(
			v_serialized_exec_func(gtk_range_get_value, GTK_RANGE(info)),
			min, step);
		flags &= ~VSF_VALUE;
	}

	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VSlider::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(gtk_range_set_value, GTK_RANGE(info), (gdouble)s->value);
		err.subcode1 &= ~VSF_VALUE;
	}
	
	V_OP_END
	
	if ( flags & ( VSF_ALIGN | VSF_PADDING ) ) {
		sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~( VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

void
VSlider::redraw(VRect* rect) const
{
}
