/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "machine/v_types.h"
#include "memory_debug.h"
#include "machine/msequence.h"

VDISPLAY * disp_list;

int v_get_font(LC_FONT *,LC_FONT_ENGINE *);

LC_FONT_ENGINE_TYPE win_font_engine_type = {
        "WindowsGDI",
        v_get_font,
        v_get_string_pic,
        0,
        {0,0},
        0
};

typedef struct v_open_disp_s {
	VDISPLAY *		ret;
	VERROR *		err;
} V_OPEN_DISP_S;

int
_v_open_disp(V_OPEN_DISP_S * buf)
{
VDISPLAY * d;
	d = d_alloc(sizeof(*d));
	d->next = disp_list;
	disp_list = d;
	buf->ret = d;

	d->fe.work = (void*)d;
	d->fe.type = &win_font_engine_type;
	d->fe.name = "Main";
	insert_font_engine(&d->fe);

	return 0;
}

VDISPLAY *
v_open_disp(VERROR * err)
{
V_OPEN_DISP_S v;
	v.err = err;
	v.ret = 0;
	ms_do(_v_open_disp,&v,"v_open_disp");
	return v.ret;
}
