/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VGroupBox.h"
#include "VApplication.h"
#include "vobject_main.h"
#include "vwin_control.h"

extern HWND CreateButtonWindow(int exStyle, int style, HWND hwnd, int id);

VExError 
VGroupBox::create_do(const VObjectStatus* s, int flags, VObject *parent, void * arg)
{
	label_size.w = label_size.h = 0;
	
	DWORD style=WS_CHILD | BS_GROUPBOX;
	if(!s->enabled){
		style |= WS_DISABLED;
	}
	if(s->visible){
		style |= WS_VISIBLE;
	}
	
	/* find container window that will own this button.*/
	VContainerInfo *container_info = VInfo::get_container_info(parent);
	int id = container_info->get_next_control_id();
	HWND hwnd = v_serialized_exec_func(CreateButtonWindow, WS_EX_CONTROLPARENT,
		style, container_info->get_hwnd(), id);
	info = new VContainerInfo(this, hwnd, id, 1, 0, 1, 0,
		(WNDPROC)SetWindowLong(hwnd, GWL_WNDPROC, (DWORD)VContainerInfo::WndProc));
	
	return parent->add_child_do(this);
}

void
VGroupBox::destroy_do(VObject *parent)
{
	parent->remove_child_do(this);
	if(info){
		v_serialized_exec_sub(::DestroyWindow, info->get_hwnd());
		delete info;
		info = NULL;
	}
	sts.parent->redraw();
}

VGroupBox::~VGroupBox()
{
}

VExError
VGroupBox::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = VObject::get_status(s,flags);
	win_control_default_get_status(info->get_hwnd(), s, flags, &err);
	V_OP_END
	return err;
};

VExError
VGroupBox::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VSize last_size = sts.min_size;
	VExError err = VObject::set_status(s,flags);
	HWND hwnd = info->get_hwnd();
	win_control_default_set_status(hwnd, s, flags&~VSF_DESC, &err);

	if ( flags & VSF_CALC_MIN ) {
		// min is calculated when desc is set
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	
	if ( flags & (VSF_DESC | VSF_FSIZE | VSF_WS) ) {
		v_set_descriptor(info, sts.descriptor, sts.ws, sts.fsize, 0, &label_size);
		err.subcode1 &= ~(VSF_DESC | VSF_FSIZE | VSF_WS);
	}

	if ( flags & VSF_CALC_MIN ) {
		if (sts.children)
			sts.children->object->set_status(0, VSF_CALC_MIN);
		VLayout layout;
		VSize lt = {1,label_size.h+3}, rb = {1,1};
		layout.set_margin(lt, rb);
		layout.layout_in_frame(this, true);
		sts.min_size = layout.parent_min_size();
		err.subcode1 &= ~ VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		VSize lt = {1,label_size.h+3}, rb = {1,1};
		layout.set_margin(lt, rb);
		layout.layout_in_frame(this);
		layout.do_layout(this);
		err.subcode1 &= ~ VSF_LAYOUT;
	}

	if ( flags & VSF_VISIBLE ) {
		if ( s->visible != (::IsWindowVisible(info->get_hwnd())==TRUE) ){
			v_serialized_exec_sub(::ShowWindow, hwnd, s->visible ? SW_SHOW : SW_HIDE);
		}
		err.subcode1 &= ~VSF_VISIBLE;
	}

	V_OP_END
	
	if ( (flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE)) ||
		 (flags & (VSF_DESC | VSF_WS | VSF_FSIZE)) &&
			(sts.min_size.w != last_size.w ||
			 sts.min_size.h != last_size.h) )
		VLayout::mark(this);
	return err;
}


VExError VGroupBox::add_child_do(VObject* child)
{
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VGroupBox::remove_child_do(VObject* child)
{

}

void
VGroupBox::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VGroupBox::redraw(VRect *rect) const
{
	if ( ! info )
		return;
	_V_OP_START_VOID
	win_redraw(info->get_hwnd(), rect);
	V_OP_END
}
