/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	"memory_routine.h"
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"resource.h"
#include	"utils.h"
#include	"xl.h"
#include	"task.h"
#include	"lock_level.h"
#include	"pri_level.h"
#include	"rs_cache.h"
#include	"rcache.h"
#include	"save_global.h"
#include	"mx_format.h"
#include	"win_flame.h"

#define SC_OFFSET	0
#define SC_RATE		0.5
#define KEY_LIMIT_RATE	0.8

typedef struct res_matrix_t {
	Q_HEADER		h;
	XL_SEXP *		ret;
	RESOURCE *		r;
	MATRIX_TOKEN *		token;
	int			aboat_flag;
	INTEGER64		insert_time;
	int			key_cnt;
} RES_MATRIX_T;

SYS_QUEUE res_matrix_before,res_matrix_after;
void
aboat_matrix_token(MATRIX_TOKEN * t);
extern int spiral_count;

VIEW_METHOD_TBL ** vm_tbl[RT_MAX];

XL_SEXP *
gbrm_gmxStatus(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
void
insert_dirty(RESOURCE * r,GB_RECT * rct);
void
_exec_dirty(int data);
void
gc_res_matrix_func(RES_MATRIX_T*);
void
gc_res_matrix_get(RES_MATRIX_T*);
void
res_matrix_task_before(TKEY d);
void
res_matrix_task_after(TKEY d);
void
open_res_matrix(MATRIX_TOKEN * t);
void * get_res_matrix_work(RESOURCE * r);
void
res_matrix_close(MATRIX * m);
void res_matrix_new_token(MATRIX_TOKEN * t,int type);
void res_matrix_free_token(MATRIX_TOKEN * t ,int type);
int
res_matrix_trigger(int type,void * data);
int
insert_res_matrix_read_net(MATRIX_TOKEN * tk);

XLISP_ENV * resource_matrix_env;
XLISP_ENV * resource_matrix_gmxEnv;
SEM res_matrix_lock;
extern SEM res_lock;

void
init_resource_matrix()
{
XLISP_ENV * gmxEnv;


	res_matrix_lock = new_lock(LL_RES_MATRIX);
	memset(&res_matrix_before,0,sizeof(SYS_QUEUE));
	res_matrix_before.flags = QF_PRI_FIFO;
	res_matrix_before.gc_func = gc_res_matrix_func;
	res_matrix_before.gc_get = gc_res_matrix_get;
	res_matrix_before.pri = PRI_FETCH_STRONG_RES_MATRIX;
	res_matrix_before.key_func = res_matrix_task_before;
	setup_queue(&res_matrix_before);

	memset(&res_matrix_after,0,sizeof(SYS_QUEUE));
	res_matrix_after.flags = QF_FIFO;
	res_matrix_after.gc_func = gc_res_matrix_func;
	res_matrix_after.gc_get = gc_res_matrix_get;
	res_matrix_after.pri = PRI_FETCH_STRONG_RES_MATRIX;
	res_matrix_after.key_func = res_matrix_task_after;
	res_matrix_after.key_limit = 5;
	setup_queue(&res_matrix_after);
	
	resource_matrix_env = new_env(gblisp_top_env0);
	resource_matrix_gmxEnv = gmxEnv = new_env(0);
	set_env(resource_matrix_env,l_string(std_cm,"gmxStatus"),
		get_func_prim(gbrm_gmxStatus,FO_NORMAL,gmxEnv,1,-1));
	init_gmx_format(gmxEnv);
}

void
gc_resource_matrix()
{
	gc_gblisp_env(resource_matrix_env);
	gc_gblisp_env(resource_matrix_gmxEnv);
}


void
gc_res_matrix_func(RES_MATRIX_T * t)
{
	gc_gb_sexp(t->ret);
}

void
gc_res_matrix_get(RES_MATRIX_T * t)
{
	lock_mem();
	gc_set_nl(t->ret,gc_gb_sexp);
	unlock_mem();
}


int
setup_view_methods(RESOURCE * res,MATRIX_NODE * n,VIEW_METHOD_TBL ** vmt,VIEW_METHOD ** vm)
{
int ch;
int type;
VIEW_METHOD_TBL ** vmt1,**vmt_same;
int ret;
VIEW_METHOD ** rp,*r;
int same_flag;
MATRIX * m;
	if ( vmt == 0 )
		return 0;
	m = res->h.mtx;
	rp = vm;
	ret = 0;
	vmt_same = 0;
	for ( ch = 0 ; ch < m->p.channel_nos ; ch ++ ) {
		if ( !(m->channel_info[ch].flags & MF_VISU) )
			continue;
		if ( m->channel_info[ch].data_type == 0 )
			continue;
		if ( (*rp) && (*rp)->view_channel[0] == ch ) {
			r = (*rp);
			rp = &(*rp)->next;
			ch = r->view_channel[r->target_channel_nos-1];
			continue;
		}
		type = m->channel_info[ch].data_type->type;
		
		vmt1 = vmt;
		same_flag = 0;
	retry:
		for ( ; *vmt1 ; vmt1 ++ )
			if ( (*vmt1)->mdt_type == type )
				break;
		if ( *vmt1 == 0 ) {
			if ( vmt_same == 0 || same_flag )
				continue;
			if ( (*vmt_same)->mdt_type != type )
				continue;
			vmt1 = vmt_same;
			same_flag = 1;
		}
		if ( (*vmt1)->mdt_type == MDT_BLOCK ) {
			if ( n == 0 ) {
				ret ++;
				continue;
			}
			if ( n->channel[ch].sb == 0 ) {
				ret ++;
				continue;
			}
			if ( (*vmt1)->sb_tbl != n->channel[ch].sb->tbl ) {
				vmt1 ++;
				goto retry;
			}
		}
		r = d_alloc(sizeof(*r));
		memset(r,0,sizeof(*r));
		r->tbl = *vmt1;
		r->target_channel_nos = 1;
		r->view_channel = d_alloc(sizeof(int));
		r->view_channel[0] = ch;
		r->m = m;
		r->r = res;
		(*(*vmt1)->vmt_create)(r,n);
		*rp = r;
		rp = &r->next;
		ch = r->view_channel[r->target_channel_nos-1];
		vmt = vmt1+1;
		vmt_same = vmt1;
	}
	return ret;
}

VM_WORK_HEADER *
_get_vm_work_header(RESOURCE * r,VIEW_METHOD_TBL * tbl,int size)
{
VM_WORK_HEADER * ret;
	ret = r->h.vm_wk;
	for ( ; ret ; ret = ret->next ) {
		if ( ret->tbl == tbl )
			return ret;
	}
	if ( size ) {
		if ( size < sizeof(VM_WORK_HEADER) )
			size = sizeof(VM_WORK_HEADER);
		ret = d_alloc(size);
		memset(ret,0,size);
		ret->flags |= VMWF_NOT_INITIALIZE;
		ret->tbl = tbl;
		ret->next = r->h.vm_wk;
		r->h.vm_wk = ret;
	}
	return ret;
}





VM_WORK_HEADER *
get_vm_work_header(RESOURCE * r,VIEW_METHOD_TBL * tbl,int size)
{
VM_WORK_HEADER * ret;
	lock_task(res_lock);
	ret = _get_vm_work_header(r,tbl,size);
	unlock_task(res_lock,"get_vm_work_Header");
	return ret;
}



int
insert_resource_matrix(RESOURCE * r,int w_flag)
{
RES_MATRIX_T * t;
L_CHAR * filename;
MATRIX_PARAM p;
XL_SEXP * cals[MI_MAX];
MATRIX* m;
int err;
int i;
	lock_task(res_lock);
	if ( r->h.mtx_loading ) {
		unlock_task(res_lock,"insert_resource_matrix");
		return 0;
	}
	r->h.mtx_loading = 1;
	unlock_task(res_lock,"insert_resource_matrix");



	filename = get_filepath_from_file_id(r->h.cache_file_id,".mtx");
	m = open_matrix(0,filename,0,0,0);
	if ( m == 0 )
		goto next;
	err = load_matrix_header(m,O_RDWR,0644);
	if ( err == 0 ) {

ss_printf("CALL insert_resource_matrix %ls %ls\n",filename,get_url_str2(&r->h.target));

		if ( m->p.flags & MPF_PERMISSION )
			goto destroy_matrix;

		memset(&p,0,sizeof(p));
		p.write_file = matrix_standard_write_file;
		p.read_file = matrix_standard_read_file;
		p.read_net = insert_res_matrix_read_net;
		p.close_file = res_matrix_close;
		p.new_token = res_matrix_new_token;
		p.free_token = res_matrix_free_token;
		p.trigger = res_matrix_trigger;

		if ( load_mode_cal(cals,p.pri_area,m,MI_MODE_CLIENT) < 0 ) {
			close_matrix(m);
			goto next;
		}
/*
for ( i = 0 ; i < MI_MAX ; i ++ ) {
ss_printf("ACTIVE CAL = ");
if ( m->cal[i] )
print_sexp(s_stdout,m->cal[i]->data,0);
else ss_printf("ZERO");
ss_printf("\n");
}
*/
		for ( i = 0 ; i < MI_MAX ; i ++ )
			if ( cals[i] )
				break;
		if ( i == MI_MAX )
			goto destroy_matrix;
		
		err = set_matrix_param(m,&p);
		if ( err < 0 ) {
			close_matrix(m);
			goto next;
		}
		
		for ( i = 0 ; i < MI_MAX ; i ++ ) {
/*
ss_printf("CAL = ");
print_sexp(s_stdout,cals[i],0);
ss_printf("\n");
*/
			set_matrix_cal(m,i,cals[i]);
		}


		m->open_work = (void*)r;
		r->h.mtx = m;

		lock_task(res_lock);
		r->h.non_setup_vm = setup_view_methods(r,0,vm_tbl[r->h.type],&r->h.vm);
		unlock_task(res_lock,"insert_resource_matrix");

		set_matrix_mode(m,MM_STANBY);


		lock_task(res_lock);
		r->h.mtx_loading = 0;
		unlock_task(res_lock,"insert_resource_matrix");

		res_matrix_trigger(TRT_MATRIX_STANBY,(void*)m);

		d_f_ree(filename);
		return 0;
	}
	else {
	destroy_matrix:
		close_matrix(m);
	}
next:
	t = new_queue_node(sizeof(*t));
	t->ret = 0;
	t->r = r;
	t->token = 0;
	t->h.pri = 0;
	t->h.key = get_server_key(&r->h.target,0);
	d_f_ree(filename);
	return insert_queue(&res_matrix_before,t,w_flag);
}


int
insert_res_matrix_read_net(MATRIX_TOKEN * tk)
{
RESOURCE * r;
RES_MATRIX_T * t;

	r = tk->process_node->matrix->open_work;
	t = new_queue_node(sizeof(*t));
	t->ret = 0;
	t->r = 0;
	t->token = tk;
	t->h.key = get_server_key(&r->h.target,0);
	t->h.pri = tk->process_node->dim_code[0];
	tk->work = (void*)t;
	tk->aboat_func = aboat_matrix_token;
	insert_queue(&res_matrix_before,t,1);
	return 1;
}

int
check_use_in_wf(RESOURCE * r)
{
WFID_INCLUDE_RESOURCE * wir,* p;
int flags;
int use;
	use = 0;
	wir = wf_search_wfid_include_resource(r);
	for ( p = wir ; p ; p = p->next ) {
		if ( p->id == 0 )
			continue;
		flags = wf_get_flags(p->gf,p->id);
		if ( flags & WFF_HIDE )
			continue;
		use = 1;
	}
	free_wfid_include_resource(wir);
	return use;
}

void
res_matrix_task_before(TKEY d)
{
int ses;
XL_INTERPRETER * xli;
L_CHAR * key;
SYS_QUEUE * que;
RES_MATRIX_T * t;
XL_SEXP * query;
XL_SEXP * sym;
L_CHAR * f;
RESOURCE * r;
RESOURCE * lost_r;
INTEGER64 lost_time;
int use;

	que = (SYS_QUEUE *)GET_TKEY(d);
	key = touch_qkey(que);
	if ( key == 0 )
		return;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	lost_r = 0;
	lost_time = 0;
	ses = open_session(SEST_OPTIMIZE);
	for ( ; ; ) {
		gc_push(0,0,"res_matrix_task_before");
		t = delete_queue(que,sq_key_cond,key,0);
		if ( t == 0 ) {
			gc_pop(0,0);
			break;
		}
		if ( t->r ) {
			if ( t->aboat_flag ) {
				d_f_ree(t);
				gc_pop(0,0);
				break;
			}
			sym = n_get_symbol("Get");
			set_attribute(sym,l_string(std_cm,"mode"),l_string(std_cm,"meta"));
			f = get_url_filepath(&t->r->h.target);
			query = List(sym,get_string(f),-1);
			d_f_ree(f);
			t->ret = remote_session(gblisp_top_env0,ses,
				&t->r->h.target,
				0,
				l_string(std_cm,"user"),
				l_string(std_cm,"Get"),
				List(query,-1),
				0,0,0,0);
		}
		else {
			if ( t->aboat_flag ) {
				t->token->work = 0;
				matrix_token_error(t->token);
				d_f_ree(t);
				gc_pop(0,0);
				continue;
			}
			r = t->token->process_node->matrix->open_work;
			use = 1;
			if ( (r->h.loop_no - t->token->process_node->process_token_key > spiral_count*SC_RATE + SC_OFFSET) ||
				(lost_time == get_xltime() && lost_r == r) || (use=check_use_in_wf(r)) == 0 ) {
/*
ss_printf("ABORT %i %i %i - %i %i BEFORE\n",t->token->process_node->process_token_key,r->pr64.loop_no,spiral_count,
res_matrix_before.total_cnt,res_matrix_after.total_cnt);
*/
				if ( use == 0 ) {
					lost_r = r;
					lost_time = get_xltime();
				}
				t->token->work = 0;
				matrix_token_error(t->token);
				d_f_ree(t);
				gc_pop(0,0);
				continue;
			}
			lost_r = 0;
			sym = n_get_symbol("Get");
			set_attribute(sym,l_string(std_cm,"mode"),l_string(std_cm,"data"));
			f = get_url_filepath(&r->h.target);
			query = List(sym,get_string(f),
					List(n_get_symbol("quote"),
						get_sexp_from_dim_code(t->token->process_node->matrix,t->token->process_node->dim_code),
						-1),
					-1);
			d_f_ree(f);
/*
ss_printf("MATRIX DIMCODE=%s\n",pt_dc(t->token->process_node->matrix,t->token->process_node->dim_code,PTDC_PIXEL_1));
*/
			t->ret = remote_session(gblisp_top_env0,ses,
				&r->h.target,
				0,
				l_string(std_cm,"user"),
				l_string(std_cm,"Get"),
				List(query,-1),
				0,0,0,0);
/*
ss_printf("RESOURCE_MATRIX %i %i %i - %i %i BEFORE\n",t->token->process_node->process_token_key,r->h.loop_no,spiral_count,
res_matrix_before.total_cnt,res_matrix_after.total_cnt);
*/
		}
		t->insert_time = get_xltime();
		t->key_cnt = get_key_count(&res_matrix_after,key);
		insert_queue(&res_matrix_after,t,1);
		gc_pop(0,0);
	}

	release_qkey(que,key);
	d_f_ree(key);

	close_session(ses);
	close_self_interpreter();

}


#define LOCK_CNT 5
MATRIX * debug_target_matrix;
int lock_cnt;

void
res_matrix_task_after(TKEY d)
{
int ses;
XL_INTERPRETER * xli;
L_CHAR * key;
SYS_QUEUE * que;
RES_MATRIX_T * t;
XL_SEXP * cmd;
XL_SEXP * sym;
CREATE_PARAM cp;
RS_BUF b;
L_CHAR * filename;
XL_SEXP * ret;
RESOURCE * r;
int tim;
float limit;
MATRIX_PARAM mp;

	que = (SYS_QUEUE *)GET_TKEY(d);
	key = touch_qkey(que);
	if ( key == 0 )
		return;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);


	ses = open_session(SEST_OPTIMIZE);
	for ( ; ; ) {
		gc_push(0,0,"res_matrix_task_after");
		t = delete_queue(que,sq_key_cond,key,0);
		if ( t == 0 ) {
			gc_pop(0,0);
			break;
		}
		if ( t->r ) {
			if ( t->aboat_flag ) {
				goto err2;
			}
			if ( get_type(t->ret) == XLT_ERROR ) {
				ss_printf("ERROR=");
				print_sexp(s_stdout,t->ret,0);
				ss_printf("\n");
				insert_lw_service_code_flag_set(t->r,t->ret);
ss_printf("FLAGS-3 = %p %x %x\n",t->r,t->r->h.flags,RF_REQUIRED_PERMISSION);
				goto err2;
			}
			cmd = get_el_by_symbol(t->ret,l_string(std_cm,"gmxStatus"),0);
			if ( get_type(cmd) != XLT_PAIR ) {
				goto err2;
			}
			// FILE Name on the cache

			if ( t->r->h.cache_file_id == 0 ) {
				memset(&b,0,sizeof(b));
				b.r = t->r;
				set_rs_resource_cache(&b);
			}

			// FILE Lock Operation

			if ( t->r->h.cache_file_id == 0 )
				goto err2;

			filename = get_filepath_from_file_id(t->r->h.cache_file_id,".mtx");

			sym = car(cmd);
			set_attribute(sym,l_string(std_cm,"neturl"),
				get_url_str2(&t->r->h.target));
			set_attribute(sym,l_string(std_cm,"filename"),
				filename);
			set_attribute(sym,l_string(std_cm,"activePhase_mode"),
					l_string(std_cm,"client"));
/*
ss_printf("CALL gmxCreate %ls %ls\n",filename,get_url_str2(&t->r->h.target));
print_sexp(s_stdout,cmd,0);
ss_printf("\n");

ss_printf("CALL gmxCreate %ls %ls\n",filename,get_url_str2(&t->r->h.target));
*/
			d_f_ree(filename);

			memset(&cp,0,sizeof(cp));

			cp.p.write_file = matrix_standard_write_file;
			cp.p.read_file = matrix_standard_read_file;
			cp.p.read_net = insert_res_matrix_read_net;
			cp.p.close_file = res_matrix_close;
			cp.p.new_token = res_matrix_new_token;
			cp.p.free_token = res_matrix_free_token;
			cp.p.trigger = res_matrix_trigger;
			
			if ( t->r->h.flags & RF_REQUIRED_PERMISSION )
				cp.p.flags = MPF_PERMISSION;

			ret = gb_gmxCreate_matrix(&cp,resource_matrix_env,cmd,
				resource_matrix_gmxEnv,sym->symbol.field);

			if ( get_type(ret) == XLT_ERROR ) {
				print_sexp(s_stdout,ret,0);
				ss_printf("\n");
			}
			if ( cp.m ) {
				cp.m->open_work = (void*)t->r;
				t->r->h.mtx = cp.m;
				lock_task(res_lock);
				r = t->r;
				r->h.non_setup_vm = setup_view_methods(r,0,vm_tbl[r->h.type],&r->h.vm);
				unlock_task(res_lock,"matrix");
				res_matrix_trigger(TRT_MATRIX_STANBY,(void*)cp.m);
			}
		err2:
			;
			t->r->h.mtx_loading = 0;
			d_f_ree(t);
			lock_task(res_lock);
			unlock_task(res_lock,"matrix");
		}
		else {
			if ( t->aboat_flag )
				goto err;
			if ( get_type(t->ret) == XLT_ERROR ) {
				r = (RESOURCE*)t->token->process_node->matrix->open_work;
				insert_lw_service_code_flag_set(r,t->ret);
				if ( (r->h.flags & RF_REQUIRED_PERMISSION)
					&& (t->token->process_node->matrix->p.flags & MPF_PERMISSION) == 0 ) {
					memset(&mp,0,sizeof(mp));
					mp.flags = MPF_PERMISSION|t->token->process_node->matrix->p.flags;
					set_matrix_param(t->token->process_node->matrix,&mp);
					save_matrix_header(t->token->process_node->matrix);
				}
				goto err;
			}
			r = (RESOURCE*)t->token->process_node->matrix->open_work;
			if ( decode_matrix_node(t->token->process_node,t->ret) < 0 )
				goto err;

			lock_task(res_lock);
			if ( r->h.non_setup_vm )
				r->h.non_setup_vm = setup_view_methods(r,t->token->process_node,
					vm_tbl[r->h.type],&r->h.vm);
			unlock_task(res_lock,"res_matrix");

			tim = (get_xltime() - t->insert_time);
			limit = 0;
			if ( tim ) {
				limit = 2.0/tim * t->key_cnt;
				if ( limit < 1 )
					set_key_limit(&res_matrix_after,
						key,get_key_limit(&res_matrix_after,key)*KEY_LIMIT_RATE
							+ (1-KEY_LIMIT_RATE));
				else	
					set_key_limit(&res_matrix_after,
						key,get_key_limit(&res_matrix_after,key)*KEY_LIMIT_RATE
							+ (1-KEY_LIMIT_RATE)*limit);
			}
			else {
				set_key_limit(&res_matrix_after,
					key,get_key_limit(&res_matrix_after,key)+1);
			}

			debug_target_matrix = t->token->process_node->matrix;
/*
ss_printf("RRR %i %f %i\n",tim,limit,res_matrix_before.key_limit);
ss_printf("RESOURCE_MATRIX %i %i %i - %i %i\n",t->token->process_node->process_token_key,r->h.loop_no,spiral_count,
res_matrix_before.total_cnt,res_matrix_after.total_cnt);
*/
			lock_task(res_matrix_lock);
			t->token->work = 0;
			t->token->aboat_func = 0;
			insert_matrix_access(t->token,matrix_exec_cal);
			d_f_ree(t);
			unlock_task(res_matrix_lock,"res_matrix");
			goto finish1;
		err:
			lock_task(res_matrix_lock);
			t->token->work = 0;
			t->token->aboat_func = 0;
			matrix_token_error(t->token);
			d_f_ree(t);
			unlock_task(res_matrix_lock,"res_matrix");
		finish1:
			;
		}
		gc_pop(0,0);
/*
if ( lock_cnt > LOCK_CNT ) {
ss_printf("LOCK\n");
for( ; ; )
sleep_sec(1);
}
else lock_cnt ++;
*/
	}

	release_qkey(que,key);
	d_f_ree(key);

	close_session(ses);
	close_self_interpreter();

}

void * get_res_matrix_work(RESOURCE * r)
{
	return (void*)r;
}

void
res_matrix_close(MATRIX * m)
{
	close_matrix_file(m);
}


void res_matrix_new_token(MATRIX_TOKEN * t,int type)
{
	if ( type != MPT_NEW_TOKEN_NODE )
		return;
	t->work = 0;
}

void res_matrix_free_token(MATRIX_TOKEN * t ,int type)
{
	if ( type != MPT_NEW_TOKEN_NODE )
		return;
}


int
res_matrix_trigger(int type,void * data)
{
I_RECT ir;
GB_RECT rct;
REAL1 dpm;
RESOURCE * r;
//TREE_NODE * tn;
//TREE_CACHE * tc;

MATRIX * m;
MATRIX_NODE * n;
MATRIX_TOKEN * n2;
extern int spiral_count;

	switch ( type ) {
	case TRT_MATRIX_STANBY:
		m = data;
		r = m->open_work;
		dpm = r->pr64.dpm;
		rct.tl.x = rct.tl.y = 0;
		rct.br.x = m->pixel_size[0] / dpm;
		rct.br.y = m->pixel_size[1] / dpm;
		insert_dirty(r,&rct);
		_exec_dirty(1);
		return 0;
	case TRT_FINISH:
ss_printf("FINISH\n");
		_exec_dirty(1);
		return 0;
	case TRT_TOKEN:
		n2 = data;

	//		tn = n2->tn;
		m = (n =n2->process_node)->matrix;
		r = m->open_work;


		lock_task(res_lock);
		if ( r->h.non_setup_vm )
			r->h.non_setup_vm = setup_view_methods(r,n,vm_tbl[r->h.type],&r->h.vm);
		unlock_task(res_lock,"insert_resource_matrix");

		ir.tl.x = n->dim_code[1] & 
			(- (1<<(n->dim_code[0]*m->dim_divide[0]
			+ m->block_size[0])));
		ir.tl.y = n->dim_code[2] &
			(- (1<<(n->dim_code[0]*m->dim_divide[1]
			+ m->block_size[1])));
		ir.br.x = ir.tl.x +
				(1<<(n->dim_code[0] * m->dim_divide[0] +
					m->block_size[0]));
		if ( ir.br.x > m->pixel_size[0] )
			ir.br.x = m->pixel_size[0];
		ir.br.y = ir.tl.y +
				(1<<(n->dim_code[0] * m->dim_divide[1] +
					m->block_size[1]));
		if ( ir.br.y > m->pixel_size[1] )
			ir.br.y = m->pixel_size[1];
		dpm = r->pr64.dpm;
		rct.tl.x = ir.tl.x / dpm;
		rct.tl.y = ir.tl.y / dpm;
		rct.br.x = ir.br.x / dpm;
		rct.br.y = ir.br.y / dpm;
	/*
		tc = n2->tc;
		if ( n2->req_level <= tn->level ||
				tc->rt_level - n2->req_level 
				> 2*(tc->rt_level - tn->level) )
	*/
	/*
		if ( n->req_level <= n->dim_code[0] ||
				m->total_levels - n->req_level
				> 2*(m->total_levels - n->dim_code[0]) ) {

	*/
	/*
			wf_insert_dirty_rect(r,
				&rct,WFF_LUSTER_DIRTY,120,10);
	*/
/*
ss_printf("INS DIRTY RCT (%f %f)-(%f %f)\n",
rct.tl.x,rct.tl.y,rct.br.x,rct.br.y);
*/
			insert_dirty(r,&rct);

	//	}
		break;
	case TRT_CANCEL:
		n2 = data;
		if ( (MI_FETCH_1_TP <= n2->access_target_id &&
			n2->access_target_id <= MI_FETCH_2_BT) ||
			(MI_VISU_1_TP <= n2->access_target_id &&
			n2->access_target_id <= MI_VISU_2_BT) ) {


			r = n2->process_node->matrix->open_work;
			if ( (r->h.loop_no - n2->process_node->process_token_key > spiral_count*SC_RATE + SC_OFFSET) ) {
/*
ss_printf("ABORT %i %i %i - %i %i BEFORE\n",t->token->process_node->process_token_key,r->pr64.loop_no,spiral_count,
res_matrix_before.total_cnt,res_matrix_after.total_cnt);
*/
				return -1;
			}
		}
		return 0;
	default:
		er_panic("omx_trigger");
	}
	return 0;
}


XL_SEXP *
gbrm_gmxStatus(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * ret;
CREATE_PARAM cp;

	memset(&cp,0,sizeof(cp));

	cp.p.write_file = matrix_standard_write_file;
	cp.p.read_file = matrix_standard_read_file;
	cp.p.read_net = insert_res_matrix_read_net;
	cp.p.close_file = res_matrix_close;
	cp.p.new_token = res_matrix_new_token;
	cp.p.free_token = res_matrix_free_token;
	cp.p.trigger = res_matrix_trigger;

	ret = gb_gmxCreate_matrix(&cp,env,s,a,sf);
	if ( ret == 0 )
		goto open_err;

	if ( get_type(ret) == XLT_ERROR )
		return ret;

	return 0;
open_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxCreate"),
		0);
}

void
aboat_matrix_token(MATRIX_TOKEN * t)
{
RES_MATRIX_T * tk;

	lock_task(res_matrix_lock);
	tk = (RES_MATRIX_T*)t->work;
	if ( tk == 0 )
		goto end;
	tk->aboat_flag = 1;
	aboat_session(tk->ret);
end:
	unlock_task(res_matrix_lock,"aboat");
}


