/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"fa_cache.h"

XL_SEXP * gb_gmxCache();

void
init_gmxCache(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env0,l_string(std_cm,"gmxCache"),
		get_func_prim(gb_gmxCache,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
gb_gmxCache(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * size;
INTEGER64 _size;
char * e_msg;
	size = get_sf_attribute(sf,l_string(std_cm,"size"));
	if ( size == 0 ) {
		e_msg = "size";
		goto inv_param;
	}
	sscanf(n_string(std_cm,size),I64_FORMAT,&_size);
	fac_general_info.total_entries = _size/FAC_SIZE;
	return 0;
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxCache"),
		0);
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCache"),
		0);
/*
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxCache"),
		n_get_string("file path"));
*/
}

