/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"ppm_types.h"


XL_SEXP * gb_gmxCopy();

void
init_gmxCopy(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxCopy"),
		get_func_prim(gb_gmxCopy,FO_APPLICATIVE,0,2,-1));
}



XL_SEXP *
gb_gmxCopy(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MX_ENTRY * mx_src,* mx_dest;
L_CHAR * src_id,* dest_id;
int i;
int err;
char * e_msg;

int * ch_list;
int len;
XL_SEXP * d;
int copy_flags;

	e_msg = "attribute src";
	src_id = get_sf_attribute(sf,l_string(std_cm,"src"));
	if ( src_id == 0 )
		goto inv_param;
	mx_src = search_mx_entry_by_id(atoi(n_string(std_cm,src_id)));
	if ( mx_src == 0 )
		goto inv_param;
	e_msg = "attribute dest";
	dest_id = get_sf_attribute(sf,l_string(std_cm,"dest"));
	if ( dest_id == 0 )
		goto inv_param;
	mx_dest = search_mx_entry_by_id(atoi(n_string(std_cm,dest_id)));
	if ( mx_dest == 0 )
		goto inv_param;

	copy_flags = 0;
	e_msg = "too few arguments";
	len = list_length(s);
	if ( len < 2 )
		goto inv_param;
	s = cdr(s);
	d = car(s);
	if ( get_type(d) == XLT_PAIR ) {
		len = list_length(d);
		ch_list = d_alloc((len+1)*sizeof(int));
		s = d;
		for ( i = 0 ; get_type(s) == XLT_PAIR &&  i < len ; ) {
			d = car(s);
			switch ( get_type(d) ) {
			case XLT_INTEGER:
				ch_list[i++] = d->integer.data;
				break;
			case XLT_STRING:
				if ( l_strcmp(d->string.data,l_string(std_cm,"MF_SEND")) == 0 )
					copy_flags |= MF_SEND;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_FILE")) == 0 )
					copy_flags |= MF_FILE;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_VISU")) == 0 )
					copy_flags |= MF_VISU;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_SEND_FILE")) == 0 )
					copy_flags |= MF_SEND_FILE;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_SEND_VISU")) == 0 )
					copy_flags |= MF_SEND_VISU;
				else	goto type_missmatch;
				break;
			default:
				goto type_missmatch;
			}
			s = cdr(s);
		}
		ch_list[i] = -1;
	}
	else {
		ch_list = d_alloc(len*sizeof(int));
		for ( i = 0 ; get_type(s) == XLT_PAIR && i < len-1 ; ) {
			d = car(s);
			switch ( get_type(d) ) {
			case XLT_INTEGER:
				ch_list[i++] = d->integer.data;
				break;
			case XLT_STRING:
				if ( l_strcmp(d->string.data,l_string(std_cm,"MF_SEND")) == 0 )
					copy_flags |= MF_SEND;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_FILE")) == 0 )
					copy_flags |= MF_FILE;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_VISU")) == 0 )
					copy_flags |= MF_VISU;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_SEND_FILE")) == 0 )
					copy_flags |= MF_SEND_FILE;
				else if ( l_strcmp(d->string.data,l_string(std_cm,"MF_SEND_VISU")) == 0 )
					copy_flags |= MF_SEND_VISU;
				else	goto type_missmatch;
				break;
			default:
				goto type_missmatch;
			}
			s = cdr(s);
		}
		ch_list[i] = -1;
	}
	set_matrix_env(mx_dest->c.m,"create-node","enable");

	err = matrix_copy(mx_dest->c.m,mx_src->c.m,ch_list,copy_flags);
	if ( err < 0 )
		goto inv_param2;

	return 0;

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxCopy"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCopy"),
		List(n_get_string("invalida parameter"),
			n_get_string(e_msg),
			-1));
inv_param2:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCopy"),
		List(n_get_string("invalida parameter"),
			get_integer(err,0),
			-1));
}

