/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___AUTHENTIFICATION_H___
#define ___AUTHENTIFICATION_H___

#include	"machine/include.h"
#include	"long_char.h"
#include	"xl.h"

typedef struct auth_key_info {
	int			type;
#define KT_RANDOM		1
#define KT_PUBLIC_KEY		2
	int			key_id;
	unsigned char *		public_key;
	unsigned char *		private_key;
	INTEGER64		create_time;
	INTEGER64		expire_time;
} AUTH_KEY_INFO;

typedef struct auth_user {
	L_CHAR *		name;
	int			type;
/* AT_TYPE */
	int			uid;
	int			key_id;
	AUTH_KEY_INFO *		key_info;
	L_CHAR *		passwd;
	INTEGER64		expire_time;
} AUTH_USER;

typedef struct auth_service_header {
	struct auth_table *	tbl;
	L_CHAR *		service_name;
	L_CHAR *		description_url;
	L_CHAR *		description;
#define AT_UNDEF		0
#define AT_CLOSE		1
#define AT_TMP			2
#define AT_FIX_USER_PASSWD	3
#define AT_PAM_USER_PASSWD	4
#define AT_LOCALHOST_ROOT	5
#define AT_ADDRESS		6
#define AT_PUBLIC_KEY		7
#define AT_CLOSED_KEY		8
#define AT_PREPAID		9
#define AT_SEQURE_PATH		10
#define AT_VERSION		11

	unsigned		open_service_name:1;
	unsigned		open_service_type:1;
} AUTH_SERVICE_HEADER;

typedef struct auth_service_fix_user_passwd {
	AUTH_SERVICE_HEADER	h;
	L_CHAR *		user;
	L_CHAR *		passwd;
} AUTH_SERVICE_FIX_USER_PASSWD;

typedef struct auth_localhost_root_keyfile {
	struct auth_localhost_root_keyfile *	next;
	unsigned int				filename;
	unsigned int				key;
	int					auth_gc_no;
} AUTH_LOCALHOST_ROOT_KEYFILE;

typedef struct auth_service_localhost_root {
	AUTH_SERVICE_HEADER	h;
	AUTH_LOCALHOST_ROOT_KEYFILE *	keyfile;
} AUTH_SERVICE_LOCALHOST_ROOT;

typedef struct auth_service_address {
	AUTH_SERVICE_HEADER	h;
	ACCESS_PERMISSION	ap;
} AUTH_SERVICE_ADDRESS;

typedef struct auth_service_version {
	AUTH_SERVICE_HEADER	h;
	L_CHAR *		version;
} AUTH_SERVICE_VERSION;

typedef union auth_service {
	AUTH_SERVICE_HEADER		h;
	AUTH_SERVICE_FIX_USER_PASSWD	pw;
	AUTH_SERVICE_ADDRESS		ad;
	AUTH_SERVICE_VERSION		va;
	AUTH_SERVICE_LOCALHOST_ROOT	lr;
} AUTH_SERVICE;


typedef struct auth_result_header {
	union auth_result *		next;
	AUTH_SERVICE *			service;
	int				status;
#define ARS_NONE		0x01
#define ARS_DENY		0x02
#define ARS_ACCEPT		0x04

#define ARS_NOT_USE		0x08
#define ARS_REQUIRED		0x10
#define ARS_SEND_PERMIT		0x20
} AUTH_RESULT_HEADER;

typedef struct auth_result_fix_user_passwd {
	AUTH_RESULT_HEADER		h;
	L_CHAR *			user;
	L_CHAR *			passwd;
} AUTH_RESULT_FIX_USER_PASSWD;

typedef struct auth_result_localhost_root {
	AUTH_RESULT_HEADER		h;
	unsigned int			filename;
	unsigned int			key;
} AUTH_RESULT_LOCALHOST_ROOT;

typedef struct auth_result_pam_user_passwd {
	AUTH_RESULT_HEADER		h;
	L_CHAR *			user;
	L_CHAR *			passwd;
} AUTH_RESULT_PAM_USER_PASSWD;

typedef struct auth_result_address {
	AUTH_RESULT_HEADER		h;
	HOST_ADDR			ha;
} AUTH_RESULT_ADDRESS;

typedef struct auth_result_version {
	AUTH_RESULT_HEADER		h;
	L_CHAR *			version;
} AUTH_RESULT_VERSION;

typedef union auth_result {
	AUTH_RESULT_HEADER		h;
	AUTH_RESULT_FIX_USER_PASSWD	pw;
	AUTH_RESULT_PAM_USER_PASSWD	pam;
	AUTH_RESULT_ADDRESS		ad;
	AUTH_RESULT_VERSION		va;
	AUTH_RESULT_LOCALHOST_ROOT	lr;
} AUTH_RESULT;

typedef struct auth_result_list {
	struct auth_result_list *	next;
	AUTH_RESULT*			result;
	struct auth_result_list *	list;
	int				type;
} AUTH_RESULT_LIST;

typedef struct auth_service_list {
	struct auth_service_list *	next;
	AUTH_SERVICE *			service;
	struct auth_service_list *	list;
	int				type;
#define ASL_NONE		0
#define ASL_AND			1
#define ASL_OR			2
} AUTH_SERVICE_LIST;

typedef struct auth_prefix {
	struct auth_prefix *	next;
	L_CHAR *		prefix;
	char *			operation;
	AUTH_SERVICE_LIST *	at_list;
} AUTH_PREFIX;

typedef struct auth_dir {
	L_CHAR *		dir_name;
	L_CHAR *		total_path;
	struct auth_dir *	child_list;
	struct auth_dir *	child_next;
	AUTH_PREFIX *		prefix;
} AUTH_DIR;


typedef struct auth_set_server {
	AUTH_KEY_INFO *		auth_key_list;
	AUTH_USER *		auth_user_list;
	AUTH_SERVICE_LIST *	auth_service_list;
	AUTH_DIR *		auth_dir_tree;
	int			auth_gc_no;
} AUTH_SET_SERVER;

typedef struct auth_set_client {
	AUTH_SERVICE_LIST *	auth_service_list;
	AUTH_RESULT *		preset_result_list;
	AUTH_RESULT *		required_result_list;
	unsigned		enable_client_result:1;
} AUTH_SET_CLIENT;

typedef struct auth_connection_set {
	AUTH_SET_SERVER *	server_set;
	AUTH_SET_CLIENT *	client_set;
	AUTH_RESULT *		server_result;
	struct xl_interpreter *	xli;
} AUTH_CONNECTION_SET;

typedef struct auth_table {
	int			type;
	char *			name;
	unsigned		default_open_service_name:1;
	unsigned		default_open_service_type:1;
	AUTH_SERVICE *		(*new_auth_service)(AUTH_SERVICE *);
	AUTH_SERVICE *		(*parse_info)(AUTH_SERVICE *,XL_SEXP *,XL_SYM_FIELD*);
	void			(*free_auth_service)(AUTH_SERVICE *);
	void			(*server_send_sexp)(AUTH_SERVICE *,XL_SEXP*);
	void			(*client_recv_sexp)(AUTH_SERVICE *,XL_SEXP*);
	AUTH_RESULT *		(*authentification)(AUTH_CONNECTION_SET *,AUTH_SERVICE *,int type);
	void			(*gc_service)(AUTH_CONNECTION_SET*,AUTH_SERVICE *,int);
	
	AUTH_RESULT *		(*new_auth_result)(AUTH_SERVICE*,AUTH_RESULT *,int service_copy_flag);
	void			(*free_auth_result)(AUTH_RESULT *,int service_flag);
	XL_SEXP *		(*send_result_info)(AUTH_RESULT *);
	AUTH_RESULT *		(*recv_result_info)(AUTH_SET_SERVER *,XL_SEXP *);
	void			(*set_authentification_result)(AUTH_RESULT*,XL_SEXP *);
	void			(*client_transaction)(AUTH_SERVICE *,AUTH_RESULT*);
	char **			(*get_result_members)(AUTH_RESULT*);
} AUTH_TABLE;


/* authentification phase */
#define AP_SERVER_CHECK_PATH		0
#define AP_CLIENT_GET_KEY		1
#define AP_SERVER_AUTHENTIFICATION	2


void
free_auth_service_header(AUTH_SERVICE * s);
XL_SEXP * 
get_result_header_sexp(AUTH_RESULT * r);
XL_SEXP *
get_service_header_sexp(AUTH_SERVICE * s);
AUTH_SERVICE * 
get_service_header(AUTH_SET_SERVER * set,XL_SEXP * s);
AUTH_RESULT *
_search_auth_result(AUTH_RESULT * list,AUTH_SERVICE * s);
void
_delete_auth_result(AUTH_RESULT ** lst,AUTH_RESULT * target);
AUTH_SERVICE * 
new_auth_service_header(AUTH_SERVICE * s,AUTH_TABLE * tbl);
AUTH_TABLE * 
at_tbl_type_name(char * name);
AUTH_TABLE *
at_tbl(int type);



AUTH_SERVICE *
new_auth_service_fix_user_passwd(AUTH_SERVICE*);
AUTH_SERVICE *
parse_info_fix_user_passwd(AUTH_SERVICE*,XL_SEXP*,XL_SYM_FIELD*);
void free_auth_service_fix_user_passwd(AUTH_SERVICE *);
AUTH_RESULT * authentification_fix_user_passwd(AUTH_CONNECTION_SET *,AUTH_SERVICE *,int type);
AUTH_RESULT * new_auth_result_fix_user_passwd(AUTH_SERVICE*,AUTH_RESULT *,int);
void free_auth_result_fix_user_passwd(AUTH_RESULT *,int service_flag);
XL_SEXP * send_result_info_fix_user_passwd(AUTH_RESULT *);
AUTH_RESULT * recv_result_info_fix_user_passwd(AUTH_SET_SERVER *,XL_SEXP *);
void
set_authentification_result_fix_user_passwd(AUTH_RESULT * res,XL_SEXP *);
char ** 
get_result_members_fix_user_passwd(AUTH_RESULT * res);
void
server_send_sexp_fix_user_passwd(AUTH_SERVICE *,XL_SEXP*);
void
client_recv_sexp_fix_user_passwd(AUTH_SERVICE *,XL_SEXP*);
void
gc_service_localhost_root(AUTH_CONNECTION_SET * set,AUTH_SERVICE * sv,int);

char ** 
get_result_members_localhost_root(AUTH_RESULT * res);
void
set_authentification_result_localhost_root(AUTH_RESULT * res,XL_SEXP *sv);
AUTH_RESULT * 
recv_result_info_localhost_root(AUTH_SET_SERVER * set,XL_SEXP * s);
XL_SEXP * 
send_result_info_localhost_root(AUTH_RESULT * r);
void 
free_auth_result_localhost_root(AUTH_RESULT * res,int service_flag);
AUTH_RESULT * 
new_auth_result_localhost_root(AUTH_SERVICE * s,AUTH_RESULT * r,int service_copy_flag);
AUTH_RESULT *
authentification_localhost_root(AUTH_CONNECTION_SET * set,AUTH_SERVICE * s,int type);
AUTH_SERVICE *
parse_info_localhost_root(AUTH_SERVICE* sv,XL_SEXP* s,XL_SYM_FIELD* sf);
void
free_auth_service_localhost_root(AUTH_SERVICE * s);
AUTH_SERVICE *
new_auth_service_localhost_root(AUTH_SERVICE* service);
void
client_transaction_localhost_root(AUTH_SERVICE*,AUTH_RESULT*);
void
server_send_sexp_localhost_root(AUTH_SERVICE *,XL_SEXP*);
void
client_recv_sexp_localhost_root(AUTH_SERVICE *,XL_SEXP*);




AUTH_CONNECTION_SET *
new_auth_connection_set(struct xl_interpreter * xli);
void
free_auth_connection_set(AUTH_CONNECTION_SET * set);
void
init_authentificaition(XLISP_ENV * env);
XL_SEXP *
ap_server_check_path_phase(AUTH_CONNECTION_SET * set,L_CHAR * path,char*,int*);
XL_SEXP *
ap_client_get_key(AUTH_RESULT_LIST ** res_notpermit,AUTH_CONNECTION_SET * set,XL_SEXP * service_list);
XL_SEXP *
ap_server_authentification(AUTH_CONNECTION_SET * set,XL_SEXP * result_list,L_CHAR * path,char*);
XL_SEXP *
auth_filepath_passive(XL_SEXP * path,char * operation);
AUTH_RESULT *
search_auth_result_in_client(L_CHAR * name,AUTH_TABLE * type,int,int);
void
set_authentification_result(AUTH_RESULT * res,XL_SEXP *);

#endif



