/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___AVT_H___
#define ___AVT_H___

/* FAVT ERROR CODE */

#define AVT_E_NO_OBJ		(-1)
#define AVT_E_LOAD_ERROR_1	(-2)
#define AVT_E_LOAD_ERROR_2	(-3)
#define AVT_E_BOUND		(-4)

/* FAVT Defined  END */

typedef struct avt_node {
	int			level;
	struct avt_node *	small;
	struct avt_node *	large;
	void *			data;
} AVT_NODE;

typedef struct avt_bound_list {
	struct avt_bound_list *	next;
	AVT_NODE *		node;
} AVT_BOUND_LIST;

AVT_NODE * avt_insert(AVT_NODE **,AVT_NODE *,int (*)());
AVT_NODE * avt_search(AVT_NODE *,void *,int (*)());
int avt_trace_from_small(AVT_NODE*,int (*)(),void*);
int avt_trace_from_large(AVT_NODE*,int (*)(),void*);
AVT_NODE * avt_delete(AVT_NODE **,void *,int (*)());
void avt_test(AVT_NODE *,int (*)());
AVT_BOUND_LIST *
avt_bound_search(
	int * errp,
	AVT_NODE * start,
	void *	data_min,
	void *	data_max,
	int	limit,
	int (*cmp)(),
	void * cw);


#endif

