/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___HEURISTICS_WIN_FRAME_H___
#define ___HEURISTICS_WIN_FRAME_H___

#include	"long_char.h"
#include	"gbview.h"

#define ASC_INDEX_HWF	1

typedef struct hwf {
	struct hwf *		next;
	L_CHAR *		url;
	int			flags;
#define HWFF_SEE		0x00000001
#define HWFF_USER		0x00000002
#define HWFF_ACTIVE		0x00000010
#define HWFF_IGNORE		0x00000020
} HWF;


typedef struct hwf_call {
	struct hwf_call_header * h;
	int			cnt;
	HWF *			target;
	HWF **			tail_p;
	HWF *			org_ptr;
} HWF_CALL;

typedef struct hwf_call_header {
	HWF *			org;
	int			(*func)(struct hwf_call * work);
} HWF_CALL_HEADER;

#define HWFF_TYPE_TO_FRAME	0x00000001
#define HWFF_TYPE_TO_HWF	0x00000002

void
xx_wakeup_hwf(GBVIEW_FLAME * gf,int type,char * file,int line);
#define wakeup_hwf(gf,type)	xx_wakeup_hwf(gf,type,__FILE__,__LINE__)
int toggle_hwf(int);
void init_hwf();
void close_hwf();


#endif

