/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___LUMP_H___
#define ___LUMP_H___

/*
(
([?xl version="0.1" encoding="Shift-JIS"])
(lump-info
	(option
		(destroy time(int))
		(launch time(int))
		(lump lump--position(str))
		(fade time(int) interval(int))
	)
	(entry "lump-crd-url" "dir" pri(int) distance(int) radius(int))
	...
)
)
*/


typedef struct lump_route {
	struct lump_route *	next;
	L_CHAR *		lump_crd;
	L_CHAR *		dir;
	unsigned int		pri;
	int			distance;
	int			radius;
} LUMP_ROUTE;

typedef struct lump_opt {
	int			flag;
	int			destroy;
	int			launch;
	int			fade_time;
	int			fade_interval;
	L_CHAR *		lump;
} LUMP_OPT;

typedef struct lump_info {
	L_CHAR *		crd;
} LUMP_INFO;

void init_lump_opt(LUMP_OPT * opt);
void free_lump_opt(LUMP_OPT * opt);
void free_lr(LUMP_ROUTE * lr);

XL_SEXP * image_of_lump_info(LUMP_INFO * info);
void lr_option(LUMP_OPT * opt,XL_SEXP * op);
void check_lr_opt(LUMP_OPT * opt,LUMP_ROUTE * r,L_CHAR *crd);

LUMP_ROUTE * search_lr(LUMP_ROUTE *,L_CHAR *);
int load_lump_info(LUMP_INFO *,L_CHAR * db);
void free_lump_info(LUMP_INFO *);
void save_lump_info(L_CHAR * path,LUMP_INFO * info);
char * get_lump_info_path(L_CHAR * path);
char * get_fullpath(L_CHAR * path);

LUMP_ROUTE * xx_get_lr(LUMP_OPT *,XL_SEXP *,L_CHAR *,char * ,int);
LUMP_ROUTE * xx_insert_lr(LUMP_ROUTE * lr,LUMP_ROUTE * ref,
		       int ofs,L_CHAR * comein,char * file,int line);

#define get_lr(opt,s,crd)	\
	xx_get_lr((opt),(s),(crd),__FILE__,__LINE__)
#define insert_lr(lr,ref,ofs,comein)	\
	xx_insert_lr((lr),(ref),(ofs),(comein),__FILE__,__LINE__)

#endif

