/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___RESOLVE_H___
#define ___RESOLVE_H___

#include	"net.h"

typedef struct host_entry {
	struct host_entry *	next;
	int			flags;
#define HEF_LOGHOST		0x00000001
#define HEF_ERROR		0x00010000
#define HEF_LOADING		0x00020000

	char *			canonical;
	char **			names;
	int			ips_length;
	HOST_ADDR *		ips;
	unsigned int		timer;
	unsigned int		access;
} HOST_ENTRY;


HOST_ENTRY * new_host_entry(int,int);

HOST_ENTRY * r_gethostbyaddr(HOST_ADDR a);
HOST_ENTRY * r_gethostbyname(char * name);
HOST_ADDR getHA_v4(unsigned int);
int cmp_HA(HOST_ADDR a,HOST_ADDR b);

/* entry for machine dependent */

HOST_ENTRY * intr_gethostbyaddr_rr(HOST_ADDR a);
HOST_ENTRY * intr_gethostbyname_rr(char * name);
int localhostcmp(HOST_ADDR ip,char * h);

void init_resolve();
HOST_ENTRY * _search_host_entry_byname(char * name);
void free_host_entry(HOST_ENTRY * he);
void _delete_host_entry(HOST_ENTRY * he);
void _insert_host_entry(HOST_ENTRY * he);
void _insert_host_entry(HOST_ENTRY * he);
int _cmp_he_addr(HOST_ADDR a,HOST_ENTRY * he);
int _cmp_host_entry(HOST_ENTRY * he1,HOST_ENTRY * he2);
HOST_ENTRY *  _replace_host_entry(HOST_ENTRY * he);
void _host_entry_regulation(HOST_ENTRY * he);
HOST_ENTRY * _search_host_entry_byaddr(HOST_ADDR ip);
int _cmp_he_name(char * name,HOST_ENTRY * he);
struct hostent * gethostbyaddr_rr(char * addr,int len,int type);
void  init_resolv();
struct hostent * get_new_hostent();
int name_entry_size(struct hostent * he);
int addr_entry_size(struct hostent * he);
HOST_ENTRY * machine2he_v4(struct hostent * he);

void aboat_resolve_request_init();
void aboat_resolve_request();

#endif


