/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___TR_HTML_H___
#define ___TR_HTML_H___

#include	"xl.h"
#include	"text_render.h"

typedef struct tr_html_attr_stack {
	struct tr_html_attr_stack *	next;
	TR_ATTR *			attr;
	LC_WRITING_STYLE *		ws;
	int				size;
} TR_HTML_ATTR_STACK;

typedef struct tr_html_info {
	TR_BOX_OP *		box_op;
	void *			sq_work;
	TR_BOX_ATTR		attr;
	XLISP_ENV *		base_env;
	LC_WRITING_STYLE *	default_ws;
	int			default_size;

	struct {
		TR_PTR			p;
		L_CHAR			last_output;
		XLISP_ENV *		env;
		TR_SEQUENCE * 		sq;
		TR_HTML_ATTR_STACK *	attr_stack;
	} d;
} TR_HTML_INFO;


extern XLISP_ENV * html_env;

void tr_html(TR_HTML_INFO *,XL_SEXP *,int);
TR_HTML_INFO * tr_get_html_info(XLISP_ENV * env);
XL_SEXP * tr_html_pair_non_symbol(TR_HTML_INFO * inf,XL_SEXP * s);
void tr_push_attr_stack(TR_HTML_INFO * info);
void tr_pop_attr_stack(TR_HTML_INFO * info);
void tr_html_string_data(TR_HTML_INFO *,L_CHAR * ,int);
void tr_close_html(TR_HTML_INFO * info);
void init_tr_html();
void init_html_font(XLISP_ENV * env);
void init_html_br(XLISP_ENV * env);
void init_html_center(XLISP_ENV * env);
void init_html_a(XLISP_ENV * env);
XL_SEXP * tr_html_pair_symbol(TR_HTML_INFO * inf,XL_SEXP * s);
XL_SEXP * tr_html_pair(TR_HTML_INFO * inf,XL_SEXP * s);
XL_SEXP * tr_html_integer(TR_HTML_INFO * inf,XL_SEXP * s);
XL_SEXP * tr_html_float(TR_HTML_INFO * inf,XL_SEXP * s);
XL_SEXP * tr_html_string(TR_HTML_INFO * inf,XL_SEXP * s);
void tr_html_roll_paper(TR_HTML_INFO * info,XL_SEXP * s);
void tr_html_cut_paper(TR_HTML_INFO * info,XL_SEXP * s);



#endif



