/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TABLE_VIEW_H___
#define ___V_TABLE_VIEW_H___

#include "v/VObject.h"

const int	v_table_child_hash_size = 20;

class VTableView : public VObject
{
      public:
	enum { object_type = VO_TBLV };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return MAX_CHILDREN_NO_LIMIT; }
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	struct table_set {
		short rows, cols;
	};
	static VTableView*	create(
								const VObjectStatus *s,
								int flags,
								short rows,
								short cols,
								VExError *err=0) {
		table_set arg = {rows, cols};
		return create(s, flags, &arg, err);
	}
	static VTableView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VTableView*>(
			create_tmp(internal_new, object_type, s, flags, err, arg));
	}
	
	// get/set size of table
	virtual void		get_table_size(short *rows, short *cols) {
		*rows = this->rows;  *cols = this->cols;
	}
	virtual VExError	resize_table(short rows, short cols);
	
	// put child in specified rows and cols
	virtual VExError	attach_child(VObject *child,
		short row, short col, short row_span=1, short col_span=1);
	virtual bool	get_child_place(VObject *child,
		short *row, short *col, short *row_span=0, short *col_span=0);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect = 0) const;
	
  protected:
	virtual ~VTableView();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);

	virtual void	destroy_do(VObject*);
	virtual VExError add_child_do(VObject*);
	virtual void	remove_child_do(VObject* child);
	
  private:
	short rows, cols;
	
  public:
	struct table_child_set {
		VObject	*child;
		short	row, col, row_span, col_span;
		table_child_set	*next;
	};
  private:
	table_child_set	*child_hash[v_table_child_hash_size];
	unsigned int	hash_key(VObject *child) {
		return ((unsigned)(child) >> 2) % v_table_child_hash_size;
	}
	
	table_child_set*	add_child_hash(VObject *child,
						short row, short col, short row_span, short col_span);
	void		remove_child_hash(VObject *child);
	table_child_set*	search_child_hash(VObject *child);
	
	static VObject *internal_new(){
		return new VTableView();
	}
};

#endif
