/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"utils.h"
#include	"lc_encode.h"

extern CODE_METHOD * code_list_head;
extern CODE_METHOD * code_list_tail;
extern CODE_ABB * abb_head;
extern CODE_ABB * abb_tail;


CODE_METHOD *
search_cm(char * name)
{
CODE_METHOD * cm;
CODE_ABB * a;
char * _name;
char * pp;
	_name = copy_str(name);
	for ( pp = _name; *pp ; pp ++ )
		if ( 'a' <= *pp && *pp <= 'z' )
			*pp += 'A'-'a';

	for ( cm = code_list_head ; cm ; cm = cm->next ) {
		if ( strcmp(cm->name,_name) == 0 ) {
			d_f_ree(_name);
			return cm;
		}
	}
	for ( a = abb_head ; a ; a = a->next ) {
		if ( strcmp(a->name,_name) == 0 ) {
			d_f_ree(_name);
			return a->cm;
		}
	}
	d_f_ree(_name);
	return 0;
}

CODE_METHOD *
search_cm_by_main_code(L_CHAR code)
{
CODE_METHOD * cm;
L_CHAR mask;
LCZ_SET * cp;

	mask = get_lc_mask(code);
	for ( cm = code_list_head ; cm ; cm = cm->next ) {
		cp = cm->main_code;
		if ( cp == 0 )
			continue;
		for ( ; cp->lcz != LCC_ERROR ; cp ++ ) {
			if ( cp->lcz == code )
				return cm;
			if ( (cp->lcz&(mask|cp->mask)) == 
					(code&(mask|cp->mask)) )
				return cm;
		}
	}
	return 0;
}

CODE_METHOD *
search_cm_by_lccode(L_CHAR lccode)
{
CODE_METHOD * cm;
CODE_ABB * a;

	for ( cm = code_list_head ; cm ; cm = cm->next ) {
		if ( cm->lccode == lccode )
			return cm;
	}
	for ( a = abb_head ; a ; a = a->next ) {
		if ( a->lccode == lccode )
			return a->cm;
	}
	return 0;
}

L_CHAR
search_lccode(char * name)
{
CODE_METHOD * cm;
CODE_ABB * a;

	for ( cm = code_list_head ; cm ; cm = cm->next ) {
		if ( strcmp(cm->name,name) == 0 )
			return cm->lccode;
	}
	for ( a = abb_head ; a ; a = a->next ) {
		if ( strcmp(a->name,name) == 0 )
			return a->lccode;
	}
	return LCC_ERROR;
}
