/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"simple_alloc.h"

void er_panic(char*);


void *
smp_alloc(SIMPLE_ALLOC_T * sat,int size)
{
void * ret;
int rem;
SA_BLOCK * blk;
	rem = size % 8;
	if ( rem )
		size += 8-rem;
	if ( size >= SA_BLOCK_SIZE )
		er_panic("smp_alloc(1)");
	if ( sat->blk == 0 || (SA_BLOCK_SIZE - sat->heap_ptr < size) ) {
		blk = d_alloc(sizeof(*blk));
		blk->next = sat->blk;
		sat->blk = blk;
		sat->heap_ptr = 0;
		sat->last_alloc = 0;
	}
	ret = (void*)&sat->blk->data[sat->heap_ptr];
	sat->last_alloc = sat->heap_ptr;
	sat->heap_ptr += size;
	return ret;
}


void *
smp_realloc(SIMPLE_ALLOC_T * sat,void * ptr,int size)
{
int rem;
	rem = size % 8;
	if ( rem )
		size += 8-rem;
	if ( ptr != (void*)&sat->blk->data[sat->last_alloc] )
		er_panic("smp_realloc");
	if ( SA_BLOCK_SIZE - sat->last_alloc < size )
		er_panic("smp_realloc(2)");
	sat->heap_ptr = sat->last_alloc + size;
	return ptr;
}

void
smp_init(SIMPLE_ALLOC_T * sat)
{
	memset(sat,0,sizeof(*sat));
}

void
free_smp(SIMPLE_ALLOC_T * sat)
{
SA_BLOCK * blk;
	for ( ; sat->blk ; ) {
		blk = sat->blk;
		sat->blk = blk->next;
		d_f_ree(blk);
	}
}


