/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_SVG_UTIL_H____
#define GM_SVG_UTIL_H____

#include <stdio.h>
#include "vpf_types.h"
#include "vpf_container.h"
#include "vpf_edge.h"
#include "vpf_node.h"
#include "gm_svg_color.h"
#include "gm_tileref_aft.h"
/*
typedef enum{
	GMFT_ROAD=0,
	GMFT_COAST_LINE,
	GMFT_POLITICAL_BOUNDARY
}GM_FILE_TYPE;
*/

typedef struct{
	FILE *fp;
	VPF_RECT max_rect;
	VPF_TABLE_TYPE type;
	const GM_SVG_COLOR_TABLE *color_table;
}GM_SVG_FILE;


GM_SVG_FILE *gm_svg_write_begin(const char *filename, VPF_TABLE_TYPE type, const GM_SVG_COLOR_TABLE *color_table);
void gm_svg_write_end(GM_SVG_FILE *fp);

void gm_write_edge_svg(GM_SVG_FILE *fp, VPF_EDGE_RECORD* edge, const char *edge_code_name);
void gm_write_node_svg(GM_SVG_FILE *fp, VPF_NODE_RECORD *node, const char *edge_code_name);
void gm_write_face_edges_svg(
	GM_SVG_FILE *fp, VPF_LIST *edges, const char *face_code_name);

void gm_svg_make_code_name(char *codename, const GM_TILEREF_AFT_RECORD *tile, LONG primitive_id);

#endif

