/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_WATER_COURSE_LFT_H___
#define GM_WATER_COURSE_LFT_H___

#include "vpf_table.h"

typedef struct {
	LONG id;
	char f_code[6];
	char *nam;
	SHORT hyc;
	SHORT acc;
	SHORT exs;
	char soc[4];
	SHORT tile_id;
	LONG edg_id;
}GM_WATER_COURSE_LFT_RECORD;

void gm_water_course_lft_delete(GM_WATER_COURSE_LFT_RECORD *record);
BOOL gm_water_course_lft_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
LONG gm_water_course_lft_get_tileid(const GM_WATER_COURSE_LFT_RECORD *record);
LONG gm_water_course_lft_get_edge_id(const GM_WATER_COURSE_LFT_RECORD *record);
void gm_water_course_lft_write_information_tag(FILE *fp, const GM_WATER_COURSE_LFT_RECORD *record);

#endif

