/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_file.h"
#include "vpf_feature_class_schema_table.h"

void feature_class_schema_delete(FEATURE_CLASS_SCHEMA_RECORD *record){
	free(record->table1_key);
	free(record->table2_key);
	free(record);
}

VPF_RECORD_READER_BEGIN(
	feature_class_schema_read, 
	FEATURE_CLASS_SCHEMA_RECORD)
	VPF_READ_FIELD(id)
	VPF_READ_FIELD(feature_class)
	VPF_READ_FIELD(table1)
	VPF_READ_VARIABLE_TEXT_FIELD(table1_key)
	VPF_READ_FIELD(table2)
	VPF_READ_VARIABLE_TEXT_FIELD(table2_key)
VPF_RECORD_READER_END()
