/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_TABLE_HEADER_H___
#define VPF_TABLE_HEADER_H___

#include <stdio.h>
#include "vpf_types.h"
#include "vpf_container.h"
#include "vpf_variable_length_index.h"

#define VPF_MAX_FEATURE_COL 8
#define VPF_BUFFER_

typedef enum {
	VTT_NODE=0,
	VTT_EDGE,
	VTT_RING,
	VTT_FACE,
	VTT_DATA_QUALITY,
	VTT_GEOGRAPHIC_REFERENCE,
	VTT_COVERAGE_ATTRIBUTE,
	VTT_FEATURE_CLASS_SCHEMA,

	GMTT_TILEREF_AFT,
	GMTT_COAST_LINE_LFT,
	GMTT_ROAD_LFT,
	GMTT_RAILROAD_LFT,
	GMTT_POLITICAL_BOUNDARY_AFT,
	GMTT_OCEANSEA_AFT,
	GMTT_WATER_COURSE_LFT,
	GMTT_INLAND_WATER_AFT,
	GMTT_BUILTUP_AREA_AFT,
	GMTT_BUILTUP_AREA_PFT
}VPF_TABLE_TYPE;


typedef struct VPFCol{
	char name[17];
	char data_type;
	char number[4];
	char key_type;
	char *column_description;
	char value_description_table_name[13];
	char themantic_index[13];
	char narrative_table_name[13];
}VPF_COL;
VPF_COL *vpf_col_new();
void vpf_col_delete(VPF_COL *col);

typedef struct VPFTableHeader{
	long header_length;
	char byte_order; //L or M
	char table_description[81];
	char narrative_table[13];
	VPF_LIST *columns;
}VPF_TABLE_HEADER;

VPF_TABLE_HEADER *vpf_table_header_new();
int vpf_table_header_read(VPF_TABLE_HEADER *header, FILE *fp);
void vpf_table_header_delete(VPF_TABLE_HEADER *header);

struct VpfTable;

typedef	BOOL (*read_record_func_type)(struct VpfTable *table, FILE *fp, VPF_LIST *cols_info);
typedef	void (*delete_record_func_type)(void *record);

typedef struct {
	VPF_TABLE_TYPE table_type;
	BOOL (*read_record_func)(struct VpfTable *table, FILE *fp, VPF_LIST *cols_info);
	void (*delete_record_func)(void *record);
}VPF_TABLE_FUNCS;

typedef struct VpfTable{
	VPF_TABLE_TYPE type;
	VPF_TABLE_HEADER *header;
	VPF_LIST *records;
	VPF_TABLE_FUNCS *f;
}VPF_TABLE;

VPF_TABLE *vpf_table_new(VPF_TABLE_TYPE type);
void vpf_table_delete(VPF_TABLE *table);
int vpf_table_load(VPF_TABLE *table, const char *file_name);

BOOL is_variable_length_record(VPF_TABLE *table);

#endif

