/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef __ATTR_DATA_H__
#define __ATTR_DATA_H__

#include "kibandata.h"

/* °쥳 */
typedef struct attr_record{
	char code[32];
	/* °ꤹоݤΣɣ */
	int id;
	/* ° */
	int attr_count;
	/* ° */
	char *pszAttrs[20];
} ATTR_RECORD;

/* °եΥǡ */
typedef struct attr_data{
	KIBAN_FILE_HEADER header;
	ATTR_RECORD *record;
} ATTR_DATA;

/* °ǡɤ߹ */
int ReadAttr(const char *filename, FILE *fp, ATTR_DATA *pAttr);
int Attr2XML(FILE *fp, ATTR_DATA *pAttr);
int AttrRecord2XML(FILE *fp, ATTR_RECORD *pAttrRecord);
ATTR_RECORD *FindAttrRecordFromAttrDataByID(ATTR_DATA *pAttr, int nID); 

ATTR_DATA *malloc_attr_data();
void free_attr_data(ATTR_DATA *pData);

#endif

