/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"



XL_SEXP *
xl_mxLoadSB(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxLoadSB(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxLoadSB"),
		get_func_prim(xl_mxLoadSB,FO_APPLICATIVE,0,1,1));
}


XL_SEXP *
xl_mxLoadSB(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * _ch;
int ch;
MATRIX_TOKEN * t;
MATRIX * m;
MATRIX_NODE * n;
int ret;
//char * e_param;
	t = get_env_work(env);
	n = t->process_node;
	m = n->matrix;
	_ch = get_sf_attribute(sf,l_string(std_cm,"channel"));
	if ( _ch ) {
		ch = atoi(n_string(std_cm,_ch));
		matrix_node_channel_lock(n);
		if ( m->channel_info[ch].data_type != &mx_type_block )
			goto next1;
		if ( n->channel[ch].sb == 0 )
			goto next1;
		ret = (*n->channel[ch].sb->tbl->block2struct)(n->channel[ch].sb,n->channel[ch].data);
		get_matrix_update_time(n,ch,UT_EQU);
		if ( ret < 0 ) {
			matrix_node_channel_unlock(n,0);
			goto inv_param2;
		}
	next1:
		matrix_node_channel_unlock(n,0);
	}
	else {
		matrix_node_channel_lock(n);
		for ( ch = 0 ; ch < m->p.channel_nos ; ch ++ ) {
			if ( m->channel_info[ch].data_type != &mx_type_block )
				continue;
			if ( n->channel[ch].sb == 0 )
				continue;
			ret = (*n->channel[ch].sb->tbl->block2struct)(n->channel[ch].sb,n->channel[ch].data);
			get_matrix_update_time(n,ch,UT_EQU);
			if ( ret < 0 ) {
				matrix_node_channel_unlock(n,0);
				goto inv_param2;
			}
		}
		matrix_node_channel_unlock(n,0);
	}
	return 0;
/*
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxLoadSB"),
		List(n_get_string("invalid parameter in mxLoadSB"),
			n_get_string(e_param),-1));
*/
inv_param2:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxLoadSB"),
		List(n_get_string("invalid parameter in mxLoadSB"),
			get_integer(ret,0),-1));
}

