/**********************************************************************
 
	Copyright (C) 2006 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "memory_debug.h"
#include "mx_blk_s_array.h"
#include "xlerror.h"

typedef struct sa_array {
	int			start;
	int			end;
	union {
		MX_STRUCT_BLOCK *	d[1];
		struct sa_array *	a[1];
	} p;
} SA_ARRAY;

#define SA_ARRAY_SIZE(x)	((int)(&(((SA_ARRAY*)0)->p.d[x])))

typedef struct sa_struct_block {
	MX_STRUCT_BLOCK		h;
	MX_STRUCT_BLOCK *	member;
	SA_ARRAY *		index;
} SA_STRUCT_BLOCK;


MX_STRUCT_BLOCK * sa_new_sb(MX_SB_NEW*,void*);
MX_STRUCT_BLOCK * sa_copy_sb(MX_STRUCT_BLOCK*);
int  sa_block2struct(MX_STRUCT_BLOCK*,MATRIX_ALLOC_BLOCK_PARAM * b);
MATRIX_ALLOC_BLOCK_PARAM * sa_struct2block(MX_STRUCT_BLOCK * blk);
void sa_free_sb(MX_STRUCT_BLOCK * blk);
int sa_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param);
MX_STRUCT_BLOCK * sa_copy_sb(MX_STRUCT_BLOCK * );

MX_STRUCT_BLOCK_TBL blk_s_array_tbl = {
	sa_new_sb,
	sa_free_sb,
	sa_copy_sb,
	sa_block2struct,
	sa_struct2block,
	sa_operation
};


int sa_insert_blk(SA_STRUCT_BLOCK * rt,int * ix,MX_STRUCT_BLOCK * b)
{
int i;
SA_ARRAY ** ap1;
SA_ARRAY * nw;
	ap1 = (SA_ARRAY**)&rt->index;
	for ( i = 0 ; i < rt->h.n.m->p.dim ; i ++ ) {
		if ( *ap1 == 0 ) {
			*ap1 = d_alloc(sizeof(SA_ARRAY));
			(*ap1)->start = ix[i];
			(*ap1)->end = ix[i]+1;
		}
		if ( ix[i] < (*ap1)->start ) {
			nw = d_alloc(SA_ARRAY_SIZE((*ap1)->end-ix[i]));
			memset(nw,0,SA_ARRAY_SIZE((*ap1)->end-ix[i]));
			nw->start = ix[i];
			nw->end = (*ap1)->end;
			memcpy(&nw->p.d[(*ap1)->start-ix[i]],
				&(*ap1)->p.d[0],
				sizeof(void*)*((*ap1)->end-(*ap1)->start));
			d_f_ree(*ap1);
			*ap1 = nw;
		}
		else if ( (*ap1)->end <= ix[i] ) {
			nw = d_re_alloc(*ap1,SA_ARRAY_SIZE((*ap1)->end - (*ap1)->start));
			nw->start = (*ap1)->start;
			nw->end = ix[i]+1;
			*ap1 = nw;
		}
		nw = *ap1;
		ap1 = &nw->p.a[ix[i]-nw->start];
	}
	if ( *ap1 )
		return -1;
	*ap1 = (SA_ARRAY*)b;
	return 0;
}

int
_sa_delete_blk(SA_STRUCT_BLOCK * rt,SA_ARRAY** app,int * ix,int depth,int del_flag)
{
MX_STRUCT_BLOCK * b;
SA_ARRAY * ap;
int i;
	ap = *app;
	if ( ap == 0 )
		return -1;
	if ( ix[depth] < ap->start )
		return -1;
	if ( ix[depth] >= ap->end )
		return -1;
	if ( depth == rt->h.n.m->p.dim - 1 ) {
		if ( ap->p.d[ix[depth]-ap->start] == 0 )
			return -1;
		if ( del_flag ) {
			b = ap->p.d[ix[depth]-ap->start];
			(*b->tbl->free_sb)(b);
		}
		ap->p.d[ix[depth]-ap->start] = 0;
	}
	else {
		_sa_delete_blk(rt,&ap->p.a[ix[depth]-ap->start],ix,depth+1,del_flag);
	}
	for ( i = 0 ; i < ap->end - ap->start ; i ++ )
		if ( ap->p.a[i] )
			return 0;
	d_f_ree(ap);
	*app = 0;
	return 0;
}

int
sa_delete_blk(SA_STRUCT_BLOCK * rt,int * ix,int del_flag)
{
	return _sa_delete_blk(rt,&rt->index,ix,0,del_flag);
}

MX_SB_LIST *
_sa_search_blk(MX_SB_LIST * lst,SA_STRUCT_BLOCK * blk,SA_ARRAY * ap1,int depth,int * work,int * ix_start,int * ix_end)
{
int start,end;
MX_SB_LIST * lst1;
int i;
	if ( ap1 == 0 )
		return lst;
	start = ix_start[depth];
	if ( ix_end )
		end = ix_end[depth];
	else	end = start+1;
	start -= ap1->start;
	if ( 0 > start )
		start = 0;
	end -= ap1->start;
	if ( ap1->end - ap1->start < end )
		end = ap1->end - ap1->start;
	if ( depth == blk->h.n.m->p.dim-1 ) {
		for ( i = start ; i < end ; i ++ ) {
			if ( ap1->p.d[i] == 0 )
				continue;
			work[depth] = i+ap1->start;
			lst1 = d_alloc(sizeof(*lst1));
			lst1->work = d_alloc(sizeof(int)*blk->h.n.m->p.dim);
			memcpy(lst1->work,work,sizeof(int)*blk->h.n.m->p.dim);
			lst1->blk = ap1->p.d[i];
			lst1->next = lst;
			lst = lst1;
		}
	}
	else {
		for ( i = start ; i < end ; i ++ ) {
			lst = _sa_search_blk(lst,blk,ap1->p.a[i],depth+1,work,ix_start,ix_end);
		}
	}
	return lst;
}

MX_SB_LIST *
sa_search_blk(SA_STRUCT_BLOCK * blk,int * ix_start,int * ix_end)
{
int * work;
MX_SB_LIST * ret;
	work = d_alloc(sizeof(int)*blk->h.n.m->p.dim);
	ret = _sa_search_blk(0,blk,blk->index,0,work,ix_start,ix_end);
	d_f_ree(work);
	return ret;
}


MX_STRUCT_BLOCK *
sa_new_sb(MX_SB_NEW * n,void * param)
{
SA_NEW * p;
SA_STRUCT_BLOCK * b;
MX_SB_NEW nn;
	nn = *n;
	if ( nn.m == 0 ) {
		if ( nn.n ) {
			nn.m = nn.n->matrix;
		}
	}
	else {
		if ( nn.n ) {
			if ( nn.n->matrix != nn.m )
				return 0;
		}
	}
	p = (SA_NEW*)param;
	b = d_alloc(sizeof(*b));
	b->h.n = nn;
	b->h.tbl = &blk_s_array_tbl;
	b->member = p->member;
	b->index = 0;
	return (MX_STRUCT_BLOCK*)b;
}

void
_sa_free_sb(MATRIX * m,SA_ARRAY * ap,int depth)
{
MX_STRUCT_BLOCK * b;
int i;
	if ( ap == 0 )
		return;
	if ( depth == m->p.dim-1 ) {
		for ( i = 0 ; i < ap->end - ap->start ; i ++ ) {
			b = ap->p.d[i];
			(*b->tbl->free_sb)(b);
		}
	}
	else {
		for ( i = 0 ; i < ap->end - ap->start ; i ++ ) {
			_sa_free_sb(m,ap->p.a[i],depth+1);
		}
	}
}

void
sa_free_sb(MX_STRUCT_BLOCK * sb)
{
SA_STRUCT_BLOCK * _sb;
	_sb = (SA_STRUCT_BLOCK *)sb;
	_sa_free_sb(_sb->h.n.m,_sb->index,0);
	(*_sb->member->tbl->free_sb)(_sb->member);
	d_f_ree(_sb);
}


void
_sa_copy_sb(SA_STRUCT_BLOCK * ret,SA_STRUCT_BLOCK * b,SA_ARRAY * ap,int * work,int depth)
{
int i;
	if ( depth == b->h.n.m->p.dim - 1 ) {
		for ( i = 0 ; i < ap->end - ap->start ; i ++ ) {
			work[depth] = i + ap->start;
			if ( ap->p.d[i] )
				sa_insert_blk(ret,work,
					(*ap->p.d[i]->tbl->copy_sb)(ap->p.d[i]));
		}
	}
	else {
		for ( i = 0 ; i < ap->end - ap->start ; i ++ ) {
			work[depth] = i + ap->start;
			_sa_copy_sb(ret,b,ap->p.a[i],work,depth+1);
		}
	}
}

MX_STRUCT_BLOCK *
sa_copy_sb(MX_STRUCT_BLOCK * b)
{
SA_STRUCT_BLOCK * _b;
MX_STRUCT_BLOCK * ret;
SA_NEW n;
int * work;
	_b = (SA_STRUCT_BLOCK*)b;
	n.member = _b->member;
	ret = sa_new_sb(&_b->h.n,&n);
	
	work = d_alloc(sizeof(int)*_b->h.n.m->p.dim);
	_sa_copy_sb((SA_STRUCT_BLOCK*)ret,_b,_b->index,work,0);
	d_f_ree(work);
	return ret;
}


int
sa_block2struct(MX_STRUCT_BLOCK * blk,MATRIX_ALLOC_BLOCK_PARAM * b)
{
SA_STRUCT_BLOCK * i_blk;
int sz;
int i;
unsigned char *ptr,* ptr2;
INTEGER64 ix;
MATRIX_ALLOC_BLOCK_PARAM p;
MATRIX * m;
MX_STRUCT_BLOCK * d_blk;
int * index;
MX_SB_LIST * lst;

	i_blk = (SA_STRUCT_BLOCK*)blk;
	m = i_blk->h.n.m;
	
	sz = b->size;
	ptr = (unsigned char*)b->block;
	for ( ; sz > 0 ; ) {
		index = d_alloc(sizeof(int)*m->p.dim);
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			if ( m->block_size[i] <= 8 ) {
				index[i] = *ptr ++;
				sz --;
			}
			else {
				ptr2 = get_uncompressed_code64(&ix,ptr);
				sz += ptr2 - ptr;
				ptr = ptr2;
				index[i] = ix;
			}
		}
		ptr2 = get_uncompressed_code64(&ix,ptr);
		sz += ptr2 - ptr;
		ptr = ptr2;
		p.size = ix;
		p.block = ptr;
		
		lst = sa_search_blk(i_blk,index,0);
		if ( lst ) {
			d_f_ree(lst->work);
			d_f_ree(lst);
			goto err1;
		}
		
		d_blk = (*i_blk->member->tbl->copy_sb)(i_blk->member);
		(*d_blk->tbl->block2struct)(d_blk,&p);
		
		sa_insert_blk(i_blk,index,d_blk);
		d_f_ree(index);
	}
	if ( sz < 0 )
		goto err0;
	return 0;
err1:
	d_f_ree(index);
err0:
	return -1;
}

void
_sa_struct2block(SA_STRUCT_BLOCK * blk,SA_ARRAY * ap,RECORD_LIST64*rl,int depth,int * work)
{
MX_STRUCT_BLOCK * b;
int i,bsize;
MATRIX_ALLOC_BLOCK_PARAM * p;
INTEGER64 ix;
int j;
unsigned char * buf,*ptr;
	if ( ap == 0 )
		return;
	bsize = ap->end - ap->start;
	if ( depth == blk->h.n.m->p.dim-1) {
		for ( i = 0 ; i < bsize ; i ++ ) {
			for ( j = 0 ; j < blk->h.n.m->p.dim ; j ++ ) {
				if ( blk->h.n.m->block_size[j] > 8 ) {
					ix = work[j];
					ptr = buf = d_alloc(sizeof(INTEGER64)*2+1);
					ptr = get_compressed_code64(buf,ix);
					set_recordlist_chain64(rl,buf,ptr-buf,1);
				}
				else {
					buf = d_alloc(1);
					*buf = work[j];
					set_recordlist_chain64(rl,buf,1,1);
				}
			}
			b = ap->p.d[i];
			p = (*b->tbl->struct2block)(b);
			if ( p ) {
				set_recordlist_chain64(rl,p->block,p->size,1);
				d_f_ree(p);
			}
		}
	}
	else {
		for ( i = 0 ; i < bsize ; i ++ ) {
			work[depth] = i + ap->start;
			_sa_struct2block(blk,ap->p.a[i],rl,depth+1,work);
		}
	}
}

MATRIX_ALLOC_BLOCK_PARAM *
sa_struct2block(MX_STRUCT_BLOCK * blk)
{
SA_STRUCT_BLOCK * i_blk;
RECORD_LIST64 * rl;
int size;
MATRIX_ALLOC_BLOCK_PARAM * p;
int * work;
	i_blk = (SA_STRUCT_BLOCK*)blk;
	
	rl = new_recordlist64(0,0);
	
	work = d_alloc(sizeof(int)*i_blk->h.n.m->p.dim);
	_sa_struct2block(i_blk,i_blk->index,rl,0,work);
	d_f_ree(work);

	size = setup_recordlist64(rl);
	
	p = d_alloc(sizeof(*p));
	memset(p,0,sizeof(*p));
	p->size = size;
	p->block = d_alloc(size);
	memcpy(p->block,rl->data,p->size);
	free_recordlist64(rl);
	return p;
}

int sa_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param)
{
int ret;
SA_OP * op;
SA_STRUCT_BLOCK * i_blk;
	i_blk = (SA_STRUCT_BLOCK*)blk;
	op = (SA_OP*)param;
	switch ( cmd ) {
	case SBOP_INSERT:
		if ( op->member ) {
			if ( op->member->tbl != blk->tbl )
				return -1;
			ret = sa_insert_blk(i_blk,op->index1,op->member);
		}
		else {
			op->member = (*i_blk->member->tbl->copy_sb)(i_blk->member);
			ret = sa_insert_blk(i_blk,op->index1,op->member);
			if ( ret < 0 ) {
				(*op->member->tbl->free_sb)(op->member);
				op->member = 0;
			}
		}
		if ( ret == 0 )
			set_dirty_file_sb(blk);
		return ret;
	case SBOP_DELETE:
		ret = sa_delete_blk(i_blk,op->index1,op->del_flag);
		if ( ret == 0 )
			set_dirty_file_sb(blk);
		return ret;
	case SBOP_REFER:
		op->member_list = sa_search_blk(i_blk,op->index1,op->index2);
		return 0;
	default:
		return -1;
	}
	return 0;
}


XL_SEXP *
xl_sbArray(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MATRIX_TOKEN * t;
MX_SB_NEW n;
SA_NEW nw;
MX_STRUCT_BLOCK * b;
XL_SEXP * mx;
XL_SEXP * ch;
char * e_param;
	mx = get_el(s,1);
	e_param = "2nd argument";
	if ( get_type(mx) != XLT_PTR )
		goto type_missmatch;
	ch = eval(env,n_get_symbol("___channel"));
	switch ( get_type(ch) )  {
	case XLT_INTEGER:
		n.channel = ch->integer.data;
		break;
	case XLT_ERROR:
		return ch;
	default:
		e_param = "___channel";
		goto type_missmatch;
	}
	t = get_env_work(env);
	n.n = t->process_node;
	n.m = n.n->matrix;
	nw.member = mx->ptr.ptr;
	b = sa_new_sb(&n,&nw);
	return get_ptr(b,0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetHTMLQuery"),
		List(n_get_string(
			"type missmatch"),
			n_get_string(e_param),
			-1));
}

void
init_sbArray(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"sbArray"),
		get_func_prim(xl_sbArray,FO_APPLICATIVE,0,2,2));
}



