/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "machine/include.h"
#include <fcntl.h>
#include <stdlib.h>
#include "ppm_types.h"
#include "ppmlib_types.h"
#include "u_file.h"

void
read_pixel(PPM_INFO * p,unsigned int w,unsigned int h,unsigned char * c)
{
int ofs,i;
unsigned char * data;
retry:
	data = get_pixel(p,w,h);
	if ( data ) {
		for ( i = 0 ; i < 3 ; i ++ )
			*c++ = *data ++;
		return;
	}
	ofs = LINE_HEAD(p,h);
	if ( ofs != p->pi_lastacc )
		u_lseek64(p->pi_fd,ofs,SEEK_SET);
	data = new_line(p,h);
	u_read(p->pi_fd,data,p->pi_width*3);
	p->pi_lastacc = ofs + p->pi_width*3;
	goto retry;
}

